/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.util;

import com.microsoft.identity.common.java.logging.Logger;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;

public class ThreadUtils {
    public static void sleepSafely(int sleepTimeInMs, @NonNull String tag, @NonNull String message) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (sleepTimeInMs > 0) {
            try {
                Thread.sleep(sleepTimeInMs);
            }
            catch (InterruptedException e) {
                Logger.info(tag, message);
                Thread.currentThread().interrupt();
            }
        }
    }

    public static ExecutorService getNamedThreadPoolExecutor(int corePool, int maxPool, int queueSize, long keepAliveTime, @NonNull TimeUnit keepAliveUnit, @NonNull String poolName) {
        if (keepAliveUnit == null) {
            throw new NullPointerException("keepAliveUnit is marked non-null but is null");
        }
        if (poolName == null) {
            throw new NullPointerException("poolName is marked non-null but is null");
        }
        if (queueSize > 0) {
            return new ThreadPoolExecutor(corePool, maxPool, keepAliveTime, keepAliveUnit, new ArrayBlockingQueue<Runnable>(queueSize), ThreadUtils.getNamedThreadFactory(poolName, System.getSecurityManager()));
        }
        if (queueSize == 0) {
            return new ThreadPoolExecutor(corePool, maxPool, keepAliveTime, keepAliveUnit, new SynchronousQueue<Runnable>(), ThreadUtils.getNamedThreadFactory(poolName, System.getSecurityManager()));
        }
        return new ThreadPoolExecutor(corePool, maxPool, keepAliveTime, keepAliveUnit, new LinkedBlockingQueue<Runnable>(), ThreadUtils.getNamedThreadFactory(poolName, System.getSecurityManager()));
    }

    private static ThreadFactory getNamedThreadFactory(final @NonNull String poolName, final SecurityManager securityManager) {
        if (poolName == null) {
            throw new NullPointerException("poolName is marked non-null but is null");
        }
        return new ThreadFactory(){
            private final String poolPrefix;
            private final AtomicLong threadNumber;
            private final ThreadGroup group;
            {
                this.poolPrefix = poolName + "-";
                this.threadNumber = new AtomicLong(1L);
                this.group = securityManager == null ? Thread.currentThread().getThreadGroup() : securityManager.getThreadGroup();
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(this.group, r, this.poolPrefix + this.threadNumber.getAndIncrement(), 0L);
                thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(@NonNull Thread t, @NonNull Throwable e) {
                        if (t == null) {
                            throw new NullPointerException("t is marked non-null but is null");
                        }
                        if (e == null) {
                            throw new NullPointerException("e is marked non-null but is null");
                        }
                        if (e instanceof ThreadDeath) {
                            Logger.info("ThreadPool[" + poolName + "]", null, "Thread Death Exception in thread pool " + poolName);
                        } else {
                            Logger.error("ThreadPool[" + poolName + "]", null, "Uncaught Exception in thread pool " + poolName, e);
                        }
                    }
                });
                return thread;
            }
        };
    }
}

