/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.util.ported;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public final class DateUtilities {
    public static final Object LOCALE_CHANGE_LOCK = new Object();
    private static final String LOCALE_PREFIX_ARABIC = "ar";
    private static final String LOCALE_PREFIX_ASSAMESE = "as";
    private static final String LOCALE_PREFIX_BENGALI = "bn";
    private static final String LOCALE_PREFIX_ALGERIAN = "dz";
    private static final String LOCALE_PREFIX_PERSIAN = "fa";
    private static final String LOCALE_PREFIX_KASHMIRI = "ks";
    private static final String LOCALE_PREFIX_MARATHI = "mr";
    private static final String LOCALE_PREFIX_BURMESE = "my";
    private static final String LOCALE_PREFIX_NEPALI = "ne";
    private static final String LOCALE_PREFIX_PUNJABI = "pa";
    private static final String LOCALE_PREFIX_PASHTO = "ps";
    private static final String LOCALE_PREFIX_URDU = "ur";
    private static final String LOCALE_PREFIX_UZBEK = "uz";
    private static final Set<String> NON_GREGORIAN_CALENDAR_LOCALES = new HashSet<String>(Arrays.asList("ar", "as", "bn", "dz", "fa", "ks", "mr", "my", "ne", "pa", "ps", "ur", "uz"));

    private DateUtilities() {
    }

    public static Date createCopy(Date date) {
        if (date != null) {
            return new Date(date.getTime());
        }
        return date;
    }

    public static long getExpiresOn(long expiresIn) {
        long currentTimeMillis = System.currentTimeMillis();
        long currentTimeSecs = TimeUnit.MILLISECONDS.toSeconds(currentTimeMillis);
        return currentTimeSecs + expiresIn;
    }

    public static boolean isLocaleCalendarNonGregorian(@NonNull Locale inputLocale) {
        if (inputLocale == null) {
            throw new NullPointerException("inputLocale is marked non-null but is null");
        }
        String localePrefix = inputLocale.getLanguage();
        return NON_GREGORIAN_CALENDAR_LOCALES.contains(localePrefix);
    }
}

