/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.util.ported;

import com.microsoft.identity.common.java.interfaces.INameValueStorage;
import com.microsoft.identity.common.java.util.ported.InMemoryStorage;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Serializable;
import java.util.Set;
import lombok.NonNull;

public class PropertyBag {
    private final INameValueStorage<Object> mMap = new InMemoryStorage<Object>();

    public <T extends Serializable> void put(@NonNull String name, @Nullable T value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.mMap.put(name, value);
    }

    @Nullable
    public <T extends Serializable> T get(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.getOrDefaultInternal(name, null);
    }

    @NonNull
    public <T extends Serializable> T getOrDefault(@NonNull String name, @NonNull T defaultValue) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return this.getOrDefaultInternal(name, defaultValue);
    }

    @NonNull
    private <T extends Serializable> T getOrDefaultInternal(@NonNull String name, @Nullable T defaultValue) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Object object = this.mMap.get(name);
        if (object == null) {
            return defaultValue;
        }
        try {
            return (T)((Serializable)object);
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    public Set<String> keySet() {
        return this.mMap.keySet();
    }
}

