/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota;

import com.microsoft.kiota.Compatibility;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.serialization.SerializationWriterFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;

public class MultipartBody
implements Parsable {
    @Nonnull
    private final String boundary = UUID.randomUUID().toString().replace("-", "");
    @Nullable
    public RequestAdapter requestAdapter;
    private final Map<String, Map.Entry<String, Object>> parts = new HashMap<String, Map.Entry<String, Object>>();
    private final Map<String, String> originalNames = new HashMap<String, String>();

    @Nonnull
    public String getBoundary() {
        return this.boundary;
    }

    public <T> void addOrReplacePart(@Nonnull String name, @Nonnull String contentType, @Nonnull T value) {
        Objects.requireNonNull(value);
        if (Compatibility.isBlank(contentType)) {
            throw new IllegalArgumentException("contentType cannot be blank or empty");
        }
        if (Compatibility.isBlank(name)) {
            throw new IllegalArgumentException("name cannot be blank or empty");
        }
        String normalizedName = this.normalizePartName(name);
        this.originalNames.put(normalizedName, name);
        this.parts.put(normalizedName, new AbstractMap.SimpleEntry<String, T>(contentType, value));
    }

    private String normalizePartName(@Nonnull String original) {
        return original.toLowerCase(Locale.ROOT);
    }

    @Nullable
    public Object getPartValue(@Nonnull String partName) {
        if (Compatibility.isBlank(partName)) {
            throw new IllegalArgumentException("partName cannot be blank or empty");
        }
        String normalizedName = this.normalizePartName(partName);
        Map.Entry<String, Object> candidate = this.parts.get(normalizedName);
        if (candidate == null) {
            return null;
        }
        return candidate.getValue();
    }

    public boolean removePart(@Nonnull String partName) {
        if (Compatibility.isBlank(partName)) {
            throw new IllegalArgumentException("partName cannot be blank or empty");
        }
        String normalizedName = this.normalizePartName(partName);
        Map.Entry<String, Object> candidate = this.parts.remove(normalizedName);
        if (candidate == null) {
            return false;
        }
        this.originalNames.remove(normalizedName);
        return true;
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        throw new UnsupportedOperationException("Unimplemented method 'getFieldDeserializers'");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        RequestAdapter ra = this.requestAdapter;
        if (ra == null) {
            throw new IllegalStateException("requestAdapter cannot be null");
        }
        if (this.parts.isEmpty()) {
            throw new IllegalStateException("multipart body cannot be empty");
        }
        SerializationWriterFactory serializationFactory = ra.getSerializationWriterFactory();
        boolean isFirst = true;
        for (Map.Entry<String, Map.Entry<String, Object>> partEntry : this.parts.entrySet()) {
            try {
                if (isFirst) {
                    isFirst = false;
                } else {
                    writer.writeStringValue("", "");
                }
                writer.writeStringValue("", "--" + this.getBoundary());
                String partContentType = partEntry.getValue().getKey();
                writer.writeStringValue("Content-Type", partContentType);
                writer.writeStringValue("Content-Disposition", "form-data; name=\"" + this.originalNames.get(partEntry.getKey()) + "\"");
                writer.writeStringValue("", "");
                Object objectValue = partEntry.getValue().getValue();
                if (objectValue instanceof Parsable) {
                    SerializationWriter partWriter = serializationFactory.getSerializationWriter(partContentType);
                    try {
                        partWriter.writeObjectValue("", (Parsable)objectValue, new Parsable[0]);
                        InputStream partContent = partWriter.getSerializedContent();
                        try {
                            if (partContent.markSupported()) {
                                partContent.reset();
                            }
                            writer.writeByteArrayValue("", Compatibility.readAllBytes(partContent));
                            continue;
                        }
                        finally {
                            if (partContent != null) {
                                partContent.close();
                            }
                            continue;
                        }
                    }
                    finally {
                        if (partWriter == null) continue;
                        partWriter.close();
                        continue;
                    }
                }
                if (objectValue instanceof String) {
                    writer.writeStringValue("", (String)objectValue);
                    continue;
                }
                if (objectValue instanceof InputStream) {
                    InputStream inputStream = (InputStream)objectValue;
                    if (inputStream.markSupported()) {
                        inputStream.reset();
                    }
                    writer.writeByteArrayValue("", Compatibility.readAllBytes(inputStream));
                    continue;
                }
                if (objectValue instanceof byte[]) {
                    writer.writeByteArrayValue("", (byte[])objectValue);
                    continue;
                }
                throw new IllegalStateException("Unsupported part type" + objectValue.getClass().getName());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        writer.writeStringValue("", "");
        writer.writeStringValue("", "--" + this.boundary + "--");
    }
}

