/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.serialization;

import com.microsoft.kiota.Compatibility;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.ParseNodeFactoryRegistry;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.serialization.SerializationWriterFactoryRegistry;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Objects;

public final class KiotaSerialization {
    private static final String CHARSET_NAME = "UTF-8";

    private KiotaSerialization() {
    }

    @Nonnull
    public static <T extends Parsable> InputStream serializeAsStream(@Nonnull String contentType, @Nonnull T value) throws IOException {
        try (SerializationWriter writer = KiotaSerialization.getSerializationWriter(contentType, value);){
            writer.writeObjectValue("", value, new Parsable[0]);
            InputStream inputStream = writer.getSerializedContent();
            return inputStream;
        }
    }

    @Nonnull
    public static <T extends Parsable> String serializeAsString(@Nonnull String contentType, @Nonnull T value) throws IOException {
        try (InputStream stream = KiotaSerialization.serializeAsStream(contentType, value);){
            String string = new String(Compatibility.readAllBytes(stream), CHARSET_NAME);
            return string;
        }
    }

    @Nonnull
    public static <T extends Parsable> InputStream serializeAsStream(@Nonnull String contentType, @Nonnull Iterable<T> values) throws IOException {
        try (SerializationWriter writer = KiotaSerialization.getSerializationWriter(contentType, values);){
            writer.writeCollectionOfObjectValues("", values);
            InputStream inputStream = writer.getSerializedContent();
            return inputStream;
        }
    }

    @Nonnull
    public static <T extends Parsable> String serializeAsString(@Nonnull String contentType, @Nonnull Iterable<T> values) throws IOException {
        try (InputStream stream = KiotaSerialization.serializeAsStream(contentType, values);){
            String string = new String(Compatibility.readAllBytes(stream), CHARSET_NAME);
            return string;
        }
    }

    private static SerializationWriter getSerializationWriter(@Nonnull String contentType, @Nonnull Object value) {
        Objects.requireNonNull(contentType);
        Objects.requireNonNull(value);
        if (contentType.isEmpty()) {
            throw new NullPointerException("content type cannot be empty");
        }
        return SerializationWriterFactoryRegistry.defaultInstance.getSerializationWriter(contentType);
    }

    @Nonnull
    public static <T extends Parsable> T deserialize(@Nonnull String contentType, @Nonnull InputStream stream, @Nonnull ParsableFactory<T> parsableFactory) {
        ParseNode parseNode = KiotaSerialization.getRootParseNode(contentType, stream, parsableFactory);
        return parseNode.getObjectValue(parsableFactory);
    }

    private static <T extends Parsable> ParseNode getRootParseNode(@Nonnull String contentType, @Nonnull InputStream stream, @Nonnull ParsableFactory<T> parsableFactory) {
        Objects.requireNonNull(contentType);
        Objects.requireNonNull(stream);
        Objects.requireNonNull(parsableFactory);
        if (contentType.isEmpty()) {
            throw new NullPointerException("content type cannot be empty");
        }
        return ParseNodeFactoryRegistry.defaultInstance.getParseNode(contentType, stream);
    }

    private static InputStream getInputStreamFromString(@Nonnull String value) throws UnsupportedEncodingException {
        Objects.requireNonNull(value);
        return new ByteArrayInputStream(value.getBytes(CHARSET_NAME));
    }

    @Nonnull
    public static <T extends Parsable> T deserialize(@Nonnull String contentType, @Nonnull String value, @Nonnull ParsableFactory<T> parsableFactory) throws IOException {
        try (InputStream stream = KiotaSerialization.getInputStreamFromString(value);){
            T t = KiotaSerialization.deserialize(contentType, stream, parsableFactory);
            return t;
        }
    }

    @Nonnull
    public static <T extends Parsable> List<T> deserializeCollection(@Nonnull String contentType, @Nonnull String value, @Nonnull ParsableFactory<T> parsableFactory) throws IOException {
        try (InputStream stream = KiotaSerialization.getInputStreamFromString(value);){
            List<T> list = KiotaSerialization.deserializeCollection(contentType, stream, parsableFactory);
            return list;
        }
    }

    @Nonnull
    public static <T extends Parsable> List<T> deserializeCollection(@Nonnull String contentType, @Nonnull InputStream stream, @Nonnull ParsableFactory<T> parsableFactory) {
        ParseNode parseNode = KiotaSerialization.getRootParseNode(contentType, stream, parsableFactory);
        return parseNode.getCollectionOfObjectValues(parsableFactory);
    }
}

