/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota;

import com.microsoft.kiota.CaseInsensitiveMap;
import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public abstract class Headers
extends CaseInsensitiveMap {
    protected Headers() {
    }

    protected Headers(@Nonnull Headers headers) {
        Objects.requireNonNull(headers);
        this.putAll(headers);
    }

    public void add(@Nonnull String key, @Nonnull String value) {
        this.addImpl(key, value, true);
    }

    public boolean tryAdd(@Nonnull String key, @Nonnull String value) {
        return this.addImpl(key, value, false);
    }

    private boolean addImpl(@Nonnull String key, @Nonnull String value, boolean appendIfPresent) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        String normalizedKey = this.normalizeKey(key);
        if (this.containsKey(normalizedKey)) {
            if (appendIfPresent) {
                Object values = this.get(normalizedKey);
                values.add(value);
                return true;
            }
        } else {
            HashSet<String> values = new HashSet<String>(1);
            values.add(value);
            this.put(normalizedKey, (Set<String>)values);
            return true;
        }
        return false;
    }

    public boolean remove(@Nonnull String key, @Nonnull String value) {
        Object values;
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        String normalizedKey = this.normalizeKey(key);
        if (this.containsKey(normalizedKey) && (values = this.get(normalizedKey)).contains(value)) {
            values.remove(value);
            if (values.isEmpty()) {
                this.remove(normalizedKey);
            }
            return true;
        }
        return false;
    }
}

