/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.http;

import com.microsoft.kiota.authentication.BaseBearerTokenAuthenticationProvider;
import com.microsoft.kiota.http.middleware.AuthorizationHandler;
import com.microsoft.kiota.http.middleware.HeadersInspectionHandler;
import com.microsoft.kiota.http.middleware.ParametersNameDecodingHandler;
import com.microsoft.kiota.http.middleware.RedirectHandler;
import com.microsoft.kiota.http.middleware.RetryHandler;
import com.microsoft.kiota.http.middleware.UserAgentHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class KiotaClientFactory {
    private KiotaClientFactory() {
    }

    @Nonnull
    public static OkHttpClient.Builder create() {
        return KiotaClientFactory.create(KiotaClientFactory.createDefaultInterceptors());
    }

    @Nonnull
    public static OkHttpClient.Builder create(@Nullable Interceptor[] interceptors) {
        Interceptor[] interceptorsOrDefault;
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(Duration.ofSeconds(100L)).readTimeout(Duration.ofSeconds(100L)).callTimeout(Duration.ofSeconds(100L));
        for (Interceptor interceptor : interceptorsOrDefault = interceptors != null ? interceptors : KiotaClientFactory.createDefaultInterceptors()) {
            builder.addInterceptor(interceptor);
        }
        return builder;
    }

    @Nonnull
    public static OkHttpClient.Builder create(@Nullable List<Interceptor> interceptors) {
        if (interceptors == null) {
            return KiotaClientFactory.create();
        }
        return KiotaClientFactory.create(new ArrayList<Interceptor>(interceptors).toArray(new Interceptor[interceptors.size()]));
    }

    @Nonnull
    public static OkHttpClient.Builder create(@Nonnull BaseBearerTokenAuthenticationProvider authenticationProvider) {
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>(KiotaClientFactory.createDefaultInterceptorsAsList());
        interceptors.add(new AuthorizationHandler(authenticationProvider));
        return KiotaClientFactory.create(interceptors);
    }

    @Nonnull
    public static Interceptor[] createDefaultInterceptors() {
        return new Interceptor[]{new RedirectHandler(), new RetryHandler(), new ParametersNameDecodingHandler(), new UserAgentHandler(), new HeadersInspectionHandler()};
    }

    @Nonnull
    public static List<Interceptor> createDefaultInterceptorsAsList() {
        return new ArrayList<Interceptor>(Arrays.asList(KiotaClientFactory.createDefaultInterceptors()));
    }
}

