/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.http;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Response;

public final class ContinuousAccessEvaluationClaims {
    private static final Pattern bearerPattern = Pattern.compile("^Bearer\\s.*", 2);
    private static final Pattern claimsPattern = Pattern.compile("\\s?claims=\"([^\"]+)\"", 2);
    private static final String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";

    private ContinuousAccessEvaluationClaims() {
    }

    @Nullable
    public static String getClaimsFromResponse(@Nonnull Response response) {
        Objects.requireNonNull(response, "parameter response cannot be null");
        if (response.code() != 401) {
            return null;
        }
        List authenticateHeader = response.headers(WWW_AUTHENTICATE_HEADER);
        if (!authenticateHeader.isEmpty()) {
            String rawHeaderValue = null;
            for (String authenticateEntry : authenticateHeader) {
                Matcher matcher = bearerPattern.matcher(authenticateEntry);
                if (!matcher.matches()) continue;
                rawHeaderValue = authenticateEntry.replaceFirst("^Bearer\\s", "");
                break;
            }
            if (rawHeaderValue != null) {
                String[] parameters;
                for (String parameter : parameters = rawHeaderValue.split(",")) {
                    Matcher matcher = claimsPattern.matcher(parameter);
                    if (!matcher.matches()) continue;
                    return matcher.group(1);
                }
            }
        }
        return null;
    }
}

