/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime.extensions;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Locale;

public final class OrtxLibrary {
    private static String libraryFileName = "onnxruntime_extensions4j_jni";
    private static final String OS_ARCH_STR = OrtxLibrary.getOsArch();

    static boolean isAndroid() {
        return System.getProperty("java.vendor", "generic").equals("The Android Project");
    }

    private static String getOsArch() {
        String detectedOS = null;
        String os = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (os.contains("mac") || os.contains("darwin")) {
            detectedOS = "osx";
        } else if (os.contains("win")) {
            detectedOS = "win";
        } else if (os.contains("nux")) {
            detectedOS = "linux";
        } else if (OrtxLibrary.isAndroid()) {
            detectedOS = "android";
        } else {
            throw new IllegalStateException("Unsupported os:" + os);
        }
        String detectedArch = null;
        String arch = System.getProperty("os.arch", "generic").toLowerCase(Locale.ENGLISH);
        if (arch.startsWith("amd64") || arch.startsWith("x86_64")) {
            detectedArch = "x64";
        } else if (arch.startsWith("x86")) {
            detectedArch = "x86";
        } else if (arch.startsWith("aarch64")) {
            detectedArch = "aarch64";
        } else if (arch.startsWith("ppc64")) {
            detectedArch = "ppc64";
        } else if (OrtxLibrary.isAndroid()) {
            detectedArch = arch;
        } else {
            throw new IllegalStateException("Unsupported arch:" + arch);
        }
        return detectedOS + '-' + detectedArch;
    }

    private static String getLibraryResourceName() {
        return "/ai/onnxruntime/extensions/native/" + OS_ARCH_STR + "/" + System.mapLibraryName("onnxruntime_extensions4j_jni");
    }

    public static String getExtractedLibraryPath() {
        if (OrtxLibrary.isAndroid()) {
            return "lib" + libraryFileName + ".so";
        }
        return libraryFileName;
    }

    private static File createTempDirectory(String prefix) throws IOException {
        String tempDir = System.getProperty("java.io.tmpdir");
        File generatedDir = new File(tempDir, prefix + System.nanoTime());
        if (!generatedDir.mkdir()) {
            throw new IOException("Failed to create temp directory " + generatedDir.getName());
        }
        return generatedDir;
    }

    public static native long getNativeExtensionOperatorRegister();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            File tempLibraryFile = null;
            if (!OrtxLibrary.isAndroid()) {
                libraryFileName = OrtxLibrary.getLibraryResourceName();
                String[] parts = libraryFileName.split("/");
                String filename = parts[parts.length - 1];
                File temporaryDir = OrtxLibrary.createTempDirectory("ortx4j");
                temporaryDir.deleteOnExit();
                tempLibraryFile = new File(temporaryDir, filename);
                try (InputStream is = OrtxLibrary.class.getResourceAsStream(libraryFileName);){
                    Files.copy(is, tempLibraryFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    tempLibraryFile.delete();
                    throw e;
                }
                catch (NullPointerException e) {
                    tempLibraryFile.delete();
                    throw new FileNotFoundException("File " + libraryFileName + " was not found inside JAR.");
                }
                libraryFileName = tempLibraryFile.getAbsolutePath();
            }
            try {
                if (OrtxLibrary.isAndroid()) {
                    System.loadLibrary(libraryFileName);
                } else {
                    System.load(libraryFileName);
                }
            }
            finally {
                if (tempLibraryFile != null) {
                    tempLibraryFile.deleteOnExit();
                }
            }
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
    }
}

