/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.tools;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.tools.Element;
import com.microsoft.playwright.tools.NestedClass;
import com.microsoft.playwright.tools.TypeRef;
import java.util.Arrays;
import java.util.List;

class Field
extends Element {
    final String name;
    final TypeRef type;

    Field(NestedClass parent, String name, JsonObject jsonElement) {
        super(parent, (JsonElement)jsonElement);
        this.name = name;
        this.type = new TypeRef(this, jsonElement.getAsJsonObject().get("type"));
    }

    void writeTo(List<String> output, String offset, String access) {
        this.writeJavadoc(output, offset, this.comment());
        if (Arrays.asList("Frame.waitForNavigation.options.url", "Page.waitForNavigation.options.url").contains(this.jsonPath)) {
            output.add(offset + "public String glob;");
            output.add(offset + "public Pattern pattern;");
            output.add(offset + "public Predicate<String> predicate;");
            return;
        }
        if (Arrays.asList("Frame.waitForFunction.options.polling", "Page.waitForFunction.options.polling").contains(this.jsonPath)) {
            output.add(offset + "public Integer pollingInterval;");
            return;
        }
        if ("Route.fulfill.response.body".equals(this.jsonPath)) {
            output.add(offset + "public String body;");
            output.add(offset + "public byte[] bodyBytes;");
            return;
        }
        if (Arrays.asList("Page.emulateMedia.params.media", "Page.emulateMedia.params.colorScheme").contains(this.jsonPath)) {
            output.add(offset + access + "Optional<" + this.type.toJava() + "> " + this.name + ";");
            return;
        }
        if (Arrays.asList("Browser.newContext.options.storageState", "Browser.newPage.options.storageState").contains(this.jsonPath)) {
            output.add(offset + access + this.type.toJava() + " " + this.name + ";");
            output.add(offset + access + "Path " + this.name + "Path;");
            return;
        }
        output.add(offset + access + this.type.toJava() + " " + this.name + ";");
    }

    void writeGetter(List<String> output, String offset) {
        output.add(offset + "public " + this.type.toJava() + " " + this.name + "() {");
        output.add(offset + "  return this." + this.name + ";");
        output.add(offset + "}");
    }

    void writeBuilderMethod(List<String> output, String offset, String parentClass) {
        if (Arrays.asList("Frame.waitForNavigation.options.url", "Page.waitForNavigation.options.url").contains(this.jsonPath)) {
            output.add(offset + "public WaitForNavigationOptions withUrl(String glob) {");
            output.add(offset + "  this.glob = glob;");
            output.add(offset + "  return this;");
            output.add(offset + "}");
            output.add(offset + "public WaitForNavigationOptions withUrl(Pattern pattern) {");
            output.add(offset + "  this.pattern = pattern;");
            output.add(offset + "  return this;");
            output.add(offset + "}");
            output.add(offset + "public WaitForNavigationOptions withUrl(Predicate<String> predicate) {");
            output.add(offset + "  this.predicate = predicate;");
            output.add(offset + "  return this;");
            output.add(offset + "}");
            return;
        }
        if (Arrays.asList("Frame.waitForFunction.options.polling", "Page.waitForFunction.options.polling").contains(this.jsonPath)) {
            output.add(offset + "public WaitForFunctionOptions withRequestAnimationFrame() {");
            output.add(offset + "  this.pollingInterval = null;");
            output.add(offset + "  return this;");
            output.add(offset + "}");
            output.add(offset + "public WaitForFunctionOptions withPollingInterval(int millis) {");
            output.add(offset + "  this.pollingInterval = millis;");
            output.add(offset + "  return this;");
            output.add(offset + "}");
            return;
        }
        if (Arrays.asList("Page.click.options.position", "Page.dblclick.options.position", "Page.hover.options.position", "Frame.click.options.position", "Frame.dblclick.options.position", "Frame.hover.options.position", "ElementHandle.click.options.position", "ElementHandle.dblclick.options.position", "ElementHandle.hover.options.position").contains(this.jsonPath)) {
            output.add(offset + "public " + parentClass + " withPosition(Position position) {");
            output.add(offset + "  this.position = position;");
            output.add(offset + "  return this;");
            output.add(offset + "}");
            output.add(offset + "public " + parentClass + " withPosition(int x, int y) {");
            output.add(offset + "  return withPosition(new Position(x, y));");
            output.add(offset + "}");
            return;
        }
        if (Arrays.asList("Page.emulateMedia.params.media", "Page.emulateMedia.params.colorScheme").contains(this.jsonPath)) {
            output.add(offset + "public " + parentClass + " with" + Field.toTitle(this.name) + "(" + this.type.toJava() + " " + this.name + ") {");
            output.add(offset + "  this." + this.name + " = Optional.ofNullable(" + this.name + ");");
            output.add(offset + "  return this;");
            output.add(offset + "}");
            return;
        }
        if (Arrays.asList("Browser.newContext.options.storageState", "Browser.newPage.options.storageState").contains(this.jsonPath)) {
            output.add(offset + "public " + parentClass + " withStorageState(BrowserContext.StorageState storageState) {");
            output.add(offset + "  this.storageState = storageState;");
            output.add(offset + "  this.storageStatePath = null;");
            output.add(offset + "  return this;");
            output.add(offset + "}");
            output.add(offset + "public " + parentClass + " withStorageState(Path storageStatePath) {");
            output.add(offset + "  this.storageState = null;");
            output.add(offset + "  this.storageStatePath = storageStatePath;");
            output.add(offset + "  return this;");
            output.add(offset + "}");
            return;
        }
        if ("Route.continue.overrides.postData".equals(this.jsonPath)) {
            output.add(offset + "public ContinueOverrides withPostData(String postData) {");
            output.add(offset + "  this.postData = postData.getBytes(StandardCharsets.UTF_8);");
            output.add(offset + "  return this;");
            output.add(offset + "}");
        }
        if ("Route.fulfill.response.body".equals(this.jsonPath)) {
            output.add(offset + "public FulfillResponse withBody(byte[] body) {");
            output.add(offset + "  this.bodyBytes = body;");
            output.add(offset + "  return this;");
            output.add(offset + "}");
        }
        if (this.name.equals("httpCredentials")) {
            output.add(offset + "public " + parentClass + " with" + Field.toTitle(this.name) + "(String username, String password) {");
            output.add(offset + "  this." + this.name + " = new " + this.type.toJava() + "(username, password);");
            output.add(offset + "  return this;");
        } else if (this.type.isNestedClass) {
            output.add(offset + "public " + this.type.toJava() + " set" + Field.toTitle(this.name) + "() {");
            output.add(offset + "  this." + this.name + " = new " + this.type.toJava() + "();");
            output.add(offset + "  return this." + this.name + ";");
        } else if ("Page.Viewport".equals(this.type.toJava()) || "Viewport".equals(this.type.toJava())) {
            output.add(offset + "public " + parentClass + " with" + Field.toTitle(this.name) + "(int width, int height) {");
            output.add(offset + "  this." + this.name + " = new " + this.type.toJava() + "(width, height);");
            output.add(offset + "  return this;");
        } else if ("Browser.VideoSize".equals(this.type.toJava()) || "VideoSize".equals(this.type.toJava())) {
            output.add(offset + "public " + parentClass + " with" + Field.toTitle(this.name) + "(int width, int height) {");
            output.add(offset + "  this." + this.name + " = new " + this.type.toJava() + "(width, height);");
            output.add(offset + "  return this;");
        } else if ("Set<Keyboard.Modifier>".equals(this.type.toJava())) {
            output.add(offset + "public " + parentClass + " with" + Field.toTitle(this.name) + "(Keyboard.Modifier... modifiers) {");
            output.add(offset + "  this." + this.name + " = new HashSet<>(Arrays.asList(modifiers));");
            output.add(offset + "  return this;");
        } else {
            output.add(offset + "public " + parentClass + " with" + Field.toTitle(this.name) + "(" + this.type.toJava() + " " + this.name + ") {");
            output.add(offset + "  this." + this.name + " = " + this.name + ";");
            output.add(offset + "  return this;");
        }
        output.add(offset + "}");
    }
}

