"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.source = void 0;
const source = "var __defProp = Object.defineProperty;\nvar __getOwnPropDesc = Object.getOwnPropertyDescriptor;\nvar __getOwnPropNames = Object.getOwnPropertyNames;\nvar __hasOwnProp = Object.prototype.hasOwnProperty;\nvar __export = (target, all) => {\n  for (var name in all)\n    __defProp(target, name, { get: all[name], enumerable: true });\n};\nvar __copyProps = (to, from, except, desc) => {\n  if (from && typeof from === \"object\" || typeof from === \"function\") {\n    for (let key of __getOwnPropNames(from))\n      if (!__hasOwnProp.call(to, key) && key !== except)\n        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });\n  }\n  return to;\n};\nvar __toCommonJS = (mod) => __copyProps(__defProp({}, \"__esModule\", { value: true }), mod);\n\n// packages/playwright-core/src/server/injected/utilityScript.ts\nvar utilityScript_exports = {};\n__export(utilityScript_exports, {\n  UtilityScript: () => UtilityScript\n});\nmodule.exports = __toCommonJS(utilityScript_exports);\n\n// packages/playwright-core/src/server/isomorphic/utilityScriptSerializers.ts\nfunction isRegExp(obj) {\n  return obj instanceof RegExp || Object.prototype.toString.call(obj) === \"[object RegExp]\";\n}\nfunction isDate(obj) {\n  return obj instanceof Date || Object.prototype.toString.call(obj) === \"[object Date]\";\n}\nfunction isError(obj) {\n  return obj instanceof Error || obj && obj.__proto__ && obj.__proto__.name === \"Error\";\n}\nfunction parseEvaluationResultValue(value, handles = []) {\n  if (Object.is(value, void 0))\n    return void 0;\n  if (typeof value === \"object\" && value) {\n    if (\"v\" in value) {\n      if (value.v === \"undefined\")\n        return void 0;\n      if (value.v === \"null\")\n        return null;\n      if (value.v === \"NaN\")\n        return NaN;\n      if (value.v === \"Infinity\")\n        return Infinity;\n      if (value.v === \"-Infinity\")\n        return -Infinity;\n      if (value.v === \"-0\")\n        return -0;\n      return void 0;\n    }\n    if (\"d\" in value)\n      return new Date(value.d);\n    if (\"r\" in value)\n      return new RegExp(value.r.p, value.r.f);\n    if (\"a\" in value)\n      return value.a.map((a) => parseEvaluationResultValue(a, handles));\n    if (\"o\" in value) {\n      const result = {};\n      for (const { k, v } of value.o)\n        result[k] = parseEvaluationResultValue(v, handles);\n      return result;\n    }\n    if (\"h\" in value)\n      return handles[value.h];\n  }\n  return value;\n}\nfunction serializeAsCallArgument(value, handleSerializer) {\n  return serialize(value, handleSerializer, /* @__PURE__ */ new Set());\n}\nfunction serialize(value, handleSerializer, visited) {\n  const result = handleSerializer(value);\n  if (\"fallThrough\" in result)\n    value = result.fallThrough;\n  else\n    return result;\n  if (visited.has(value))\n    throw new Error(\"Argument is a circular structure\");\n  if (typeof value === \"symbol\")\n    return { v: \"undefined\" };\n  if (Object.is(value, void 0))\n    return { v: \"undefined\" };\n  if (Object.is(value, null))\n    return { v: \"null\" };\n  if (Object.is(value, NaN))\n    return { v: \"NaN\" };\n  if (Object.is(value, Infinity))\n    return { v: \"Infinity\" };\n  if (Object.is(value, -Infinity))\n    return { v: \"-Infinity\" };\n  if (Object.is(value, -0))\n    return { v: \"-0\" };\n  if (typeof value === \"boolean\")\n    return value;\n  if (typeof value === \"number\")\n    return value;\n  if (typeof value === \"string\")\n    return value;\n  if (isError(value)) {\n    const error = value;\n    if (\"captureStackTrace\" in globalThis.Error) {\n      return error.stack || \"\";\n    }\n    return `${error.name}: ${error.message}\n${error.stack}`;\n  }\n  if (isDate(value))\n    return { d: value.toJSON() };\n  if (isRegExp(value))\n    return { r: { p: value.source, f: value.flags } };\n  if (Array.isArray(value)) {\n    const a = [];\n    visited.add(value);\n    for (let i = 0; i < value.length; ++i)\n      a.push(serialize(value[i], handleSerializer, visited));\n    visited.delete(value);\n    return { a };\n  }\n  if (typeof value === \"object\") {\n    const o = [];\n    visited.add(value);\n    for (const name of Object.keys(value)) {\n      let item;\n      try {\n        item = value[name];\n      } catch (e) {\n        continue;\n      }\n      if (name === \"toJSON\" && typeof item === \"function\")\n        o.push({ k: name, v: { o: [] } });\n      else\n        o.push({ k: name, v: serialize(item, handleSerializer, visited) });\n    }\n    visited.delete(value);\n    return { o };\n  }\n}\n\n// packages/playwright-core/src/server/injected/utilityScript.ts\nvar UtilityScript = class {\n  evaluate(isFunction, returnByValue, expression, argCount, ...argsAndHandles) {\n    const args = argsAndHandles.slice(0, argCount);\n    const handles = argsAndHandles.slice(argCount);\n    const parameters = args.map((a) => parseEvaluationResultValue(a, handles));\n    let result = globalThis.eval(expression);\n    if (isFunction === true) {\n      result = result(...parameters);\n    } else if (isFunction === false) {\n      result = result;\n    } else {\n      if (typeof result === \"function\")\n        result = result(...parameters);\n    }\n    return returnByValue ? this._promiseAwareJsonValueNoThrow(result) : result;\n  }\n  jsonValue(returnByValue, value) {\n    if (Object.is(value, void 0))\n      return void 0;\n    return serializeAsCallArgument(value, (value2) => ({ fallThrough: value2 }));\n  }\n  _promiseAwareJsonValueNoThrow(value) {\n    const safeJson = (value2) => {\n      try {\n        return this.jsonValue(true, value2);\n      } catch (e) {\n        return void 0;\n      }\n    };\n    if (value && typeof value === \"object\" && typeof value.then === \"function\") {\n      return (async () => {\n        const promiseValue = await value;\n        return safeJson(promiseValue);\n      })();\n    }\n    return safeJson(value);\n  }\n};\nmodule.exports = UtilityScript;\n";
exports.source = source;