/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl.driver;

import com.microsoft.playwright.impl.driver.DriverLogging;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

public abstract class Driver {
    private static Driver instance;

    public static synchronized Path ensureDriverInstalled(Map<String, String> env, Boolean installBrowsers) {
        if (instance == null) {
            try {
                instance = Driver.createDriver();
                Driver.logMessage("initializing driver");
                instance.initialize(env, installBrowsers);
                Driver.logMessage("driver initialized.");
            }
            catch (Exception exception) {
                instance = null;
                throw new RuntimeException("Failed to create driver", exception);
            }
        }
        return instance.driverPath();
    }

    protected abstract void initialize(Map<String, String> var1, Boolean var2) throws Exception;

    public Path driverPath() {
        String cliFileName = System.getProperty("os.name").toLowerCase().contains("windows") ? "playwright.cmd" : "playwright.sh";
        return this.driverDir().resolve(cliFileName);
    }

    public static void setRequiredEnvironmentVariables(ProcessBuilder pb) {
        pb.environment().put("PW_LANG_NAME", "java");
        pb.environment().put("PW_LANG_NAME_VERSION", Driver.getMajorJavaVersion());
        String version = Driver.class.getPackage().getImplementationVersion();
        if (version != null) {
            pb.environment().put("PW_CLI_DISPLAY_VERSION", version);
        }
    }

    private static String getMajorJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            return version.substring(2, 3);
        }
        int dot = version.indexOf(".");
        if (dot != -1) {
            return version.substring(0, dot);
        }
        return version;
    }

    private static Driver createDriver() throws Exception {
        String pathFromProperty = System.getProperty("playwright.cli.dir");
        if (pathFromProperty != null) {
            return new PreinstalledDriver(Paths.get(pathFromProperty, new String[0]));
        }
        String driverImpl = System.getProperty("playwright.driver.impl", "com.microsoft.playwright.impl.driver.jar.DriverJar");
        Class<?> jarDriver = Class.forName(driverImpl);
        return (Driver)jarDriver.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    protected abstract Path driverDir();

    protected static void logMessage(String message) {
        DriverLogging.logWithTimestamp("pw:install " + message);
    }

    private static class PreinstalledDriver
    extends Driver {
        private final Path driverDir;

        PreinstalledDriver(Path driverDir) {
            PreinstalledDriver.logMessage("created PreinstalledDriver: " + driverDir);
            this.driverDir = driverDir;
        }

        @Override
        protected void initialize(Map<String, String> env, Boolean installBrowsers) {
        }

        @Override
        protected Path driverDir() {
            return this.driverDir;
        }
    }
}

