/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest;

import com.google.common.io.BaseEncoding;
import java.util.Arrays;

public final class Base64Url {
    private final byte[] bytes;

    private Base64Url(String string) {
        this.bytes = (byte[])(string == null ? null : string.getBytes());
    }

    public static Base64Url encode(byte[] bytes) {
        if (bytes == null) {
            return new Base64Url(null);
        }
        return new Base64Url(BaseEncoding.base64Url().omitPadding().encode(bytes));
    }

    public byte[] getEncodedBytes() {
        return this.bytes;
    }

    public byte[] getDecodedBytes() {
        if (this.bytes == null) {
            return null;
        }
        return BaseEncoding.base64Url().decode((CharSequence)new String(this.bytes));
    }

    public String toString() {
        return new String(this.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Base64Url)) {
            return false;
        }
        Base64Url rhs = (Base64Url)obj;
        return Arrays.equals(this.bytes, rhs.getEncodedBytes());
    }
}

