/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class CustomHeadersInterceptor
implements Interceptor {
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public CustomHeadersInterceptor() {
    }

    public CustomHeadersInterceptor(String key, String value) {
        this();
        this.addHeader(key, value);
    }

    public CustomHeadersInterceptor replaceHeader(String name, String value) {
        this.headers.put(name, new ArrayList());
        this.headers.get(name).add(value);
        return this;
    }

    public CustomHeadersInterceptor addHeader(String name, String value) {
        if (!this.headers.containsKey(name)) {
            this.headers.put(name, new ArrayList());
        }
        this.headers.get(name).add(value);
        return this;
    }

    public CustomHeadersInterceptor addHeaders(Headers headers) {
        this.headers.putAll(headers.toMultimap());
        return this;
    }

    public CustomHeadersInterceptor addHeaderMap(Map<String, String> headers) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            this.headers.put(header.getKey(), Collections.singletonList(header.getValue()));
        }
        return this;
    }

    public CustomHeadersInterceptor addHeaderMultimap(Map<String, List<String>> headers) {
        this.headers.putAll(headers);
        return this;
    }

    public CustomHeadersInterceptor removeHeader(String name) {
        this.headers.remove(name);
        return this;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request.Builder builder = chain.request().newBuilder();
        for (Map.Entry<String, List<String>> header : this.headers.entrySet()) {
            for (String value : header.getValue()) {
                builder = builder.header(header.getKey(), value);
            }
        }
        return chain.proceed(builder.build());
    }
}

