/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest;

import com.google.common.util.concurrent.AbstractFuture;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseWithHeaders;
import rx.Observable;
import rx.Subscription;
import rx.functions.Action1;

public class ServiceCall<T>
extends AbstractFuture<T> {
    private Subscription subscription;

    protected ServiceCall() {
    }

    public static <T> ServiceCall<T> create(Observable<ServiceResponse<T>> observable) {
        final ServiceCall<T> serviceCall = new ServiceCall<T>();
        serviceCall.subscription = observable.last().subscribe(new Action1<ServiceResponse<T>>(){

            public void call(ServiceResponse<T> t) {
                serviceCall.set(t.getBody());
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                serviceCall.setException(throwable);
            }
        });
        return serviceCall;
    }

    public static <T> ServiceCall<T> create(Observable<ServiceResponse<T>> observable, final ServiceCallback<T> callback) {
        final ServiceCall<T> serviceCall = new ServiceCall<T>();
        serviceCall.subscription = observable.last().subscribe(new Action1<ServiceResponse<T>>(){

            public void call(ServiceResponse<T> t) {
                if (callback != null) {
                    callback.success(t.getBody());
                }
                serviceCall.set(t.getBody());
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                if (callback != null) {
                    callback.failure(throwable);
                }
                serviceCall.setException(throwable);
            }
        });
        return serviceCall;
    }

    public static <T, V> ServiceCall<T> createWithHeaders(Observable<ServiceResponseWithHeaders<T, V>> observable, final ServiceCallback<T> callback) {
        final ServiceCall<T> serviceCall = new ServiceCall<T>();
        serviceCall.subscription = observable.last().subscribe(new Action1<ServiceResponse<T>>(){

            public void call(ServiceResponse<T> t) {
                if (callback != null) {
                    callback.success(t.getBody());
                }
                serviceCall.set(t.getBody());
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                if (callback != null) {
                    callback.failure(throwable);
                }
                serviceCall.setException(throwable);
            }
        });
        return serviceCall;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    protected void setSubscription(Subscription subscription) {
        this.subscription = subscription;
    }

    public boolean success(T result) {
        return this.set(result);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        this.subscription.unsubscribe();
        return super.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.subscription.isUnsubscribed();
    }
}

