/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest;

import com.microsoft.rest.BaseUrlHandler;
import com.microsoft.rest.CustomHeadersInterceptor;
import com.microsoft.rest.UserAgentInterceptor;
import com.microsoft.rest.retry.RetryHandler;
import com.microsoft.rest.serializer.JacksonMapperAdapter;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import okhttp3.CookieJar;
import okhttp3.Interceptor;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;

public abstract class ServiceClient {
    private OkHttpClient httpClient;
    private Retrofit retrofit;
    private JacksonMapperAdapter mapperAdapter;

    protected ServiceClient(String baseUrl) {
        this(baseUrl, new OkHttpClient.Builder(), new Retrofit.Builder());
    }

    protected ServiceClient(String baseUrl, OkHttpClient.Builder clientBuilder, Retrofit.Builder restBuilder) {
        if (clientBuilder == null) {
            throw new IllegalArgumentException("clientBuilder == null");
        }
        if (restBuilder == null) {
            throw new IllegalArgumentException("restBuilder == null");
        }
        this.mapperAdapter = new JacksonMapperAdapter();
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        this.httpClient = clientBuilder.cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)cookieManager)).addInterceptor((Interceptor)new UserAgentInterceptor()).addInterceptor((Interceptor)new BaseUrlHandler()).addInterceptor((Interceptor)new CustomHeadersInterceptor()).addInterceptor((Interceptor)new RetryHandler()).build();
        this.retrofit = restBuilder.baseUrl(baseUrl).client(this.httpClient).addConverterFactory((Converter.Factory)this.mapperAdapter.getConverterFactory()).addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).build();
    }

    public Retrofit retrofit() {
        return this.retrofit;
    }

    public OkHttpClient httpClient() {
        return this.httpClient;
    }

    public JacksonMapperAdapter mapperAdapter() {
        return this.mapperAdapter;
    }
}

