/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.rest.RestException;
import com.microsoft.rest.ServiceException;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.serializer.JacksonMapperAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import retrofit2.Response;

public class ServiceResponseBuilder<T, E extends RestException> {
    protected Map<Integer, Type> responseTypes;
    protected Class<? extends RestException> exceptionType;
    protected JacksonMapperAdapter mapperAdapter;

    public ServiceResponseBuilder(JacksonMapperAdapter mapperAdapter) {
        this(mapperAdapter, new HashMap<Integer, Type>());
    }

    public ServiceResponseBuilder(JacksonMapperAdapter mapperAdapter, Map<Integer, Type> responseTypes) {
        this.mapperAdapter = mapperAdapter;
        this.responseTypes = responseTypes;
        this.exceptionType = ServiceException.class;
        this.responseTypes.put(0, (Type)((Object)Object.class));
    }

    public ServiceResponseBuilder<T, E> register(int statusCode, Type type) {
        this.responseTypes.put(statusCode, type);
        return this;
    }

    public ServiceResponseBuilder<T, E> registerError(Class<? extends RestException> type) {
        this.exceptionType = type;
        try {
            Field f = type.getDeclaredField("body");
            this.responseTypes.put(0, f.getType());
        }
        catch (NoSuchFieldException e) {
            this.responseTypes.put(0, (Type)((Object)Object.class));
        }
        return this;
    }

    public ServiceResponseBuilder<T, E> registerAll(Map<Integer, Type> responseTypes) {
        this.responseTypes.putAll(responseTypes);
        return this;
    }

    public ServiceResponse<T> build(Response<ResponseBody> response) throws E, IOException {
        if (response == null) {
            return null;
        }
        int statusCode = response.code();
        ResponseBody responseBody = response.isSuccessful() ? (ResponseBody)response.body() : response.errorBody();
        if (this.responseTypes.containsKey(statusCode)) {
            return new ServiceResponse<Object>(this.buildBody(statusCode, responseBody), response);
        }
        if (response.isSuccessful() && this.responseTypes.size() == 1) {
            return new ServiceResponse<Object>(this.buildBody(statusCode, responseBody), response);
        }
        try {
            String responseContent = responseBody.string();
            responseBody = ResponseBody.create((MediaType)responseBody.contentType(), (String)responseContent);
            RestException exception = this.exceptionType.getConstructor(String.class).newInstance(responseContent);
            this.exceptionType.getMethod("setResponse", response.getClass()).invoke((Object)exception, response);
            this.exceptionType.getMethod("setBody", (Class)this.responseTypes.get(0)).invoke((Object)exception, this.buildBody(statusCode, responseBody));
            throw exception;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException("Invalid status code " + statusCode + ", but an instance of " + this.exceptionType.getCanonicalName() + " cannot be created.", e);
        }
    }

    public ServiceResponse<T> buildEmpty(Response<Void> response) throws E, IOException {
        int statusCode = response.code();
        if (this.responseTypes.containsKey(statusCode)) {
            return new ServiceResponse(response);
        }
        if (response.isSuccessful() && this.responseTypes.size() == 1) {
            return new ServiceResponse(response);
        }
        try {
            RestException exception = this.exceptionType.getConstructor(String.class).newInstance("Invalid status code " + statusCode);
            this.exceptionType.getMethod("setResponse", response.getClass()).invoke((Object)exception, response);
            response.errorBody().close();
            throw exception;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException("Invalid status code " + statusCode + ", but an instance of " + this.exceptionType.getCanonicalName() + " cannot be created.", e);
        }
    }

    public <THeader> ServiceResponseWithHeaders<T, THeader> buildWithHeaders(Response<ResponseBody> response, Class<THeader> headerType) throws E, IOException {
        ServiceResponse<T> bodyResponse = this.build(response);
        Object headers = this.mapperAdapter.deserialize(this.mapperAdapter.serialize(response.headers()), headerType);
        return new ServiceResponseWithHeaders(bodyResponse.getBody(), headers, bodyResponse.getResponse());
    }

    public <THeader> ServiceResponseWithHeaders<T, THeader> buildEmptyWithHeaders(Response<Void> response, Class<THeader> headerType) throws E, IOException {
        ServiceResponse<T> bodyResponse = this.buildEmpty(response);
        Object headers = this.mapperAdapter.deserialize(this.mapperAdapter.serialize(response.headers()), headerType);
        ServiceResponseWithHeaders serviceResponse = new ServiceResponseWithHeaders(headers, bodyResponse.getHeadResponse());
        serviceResponse.setBody(bodyResponse.getBody());
        return serviceResponse;
    }

    protected Object buildBody(int statusCode, ResponseBody responseBody) throws IOException {
        if (responseBody == null) {
            return null;
        }
        Type type = this.responseTypes.containsKey(statusCode) ? this.responseTypes.get(statusCode) : (this.responseTypes.get(0) != Object.class ? this.responseTypes.get(0) : new TypeReference<T>(){}.getType());
        if (type == Void.class) {
            return null;
        }
        if (type == InputStream.class) {
            InputStream stream = responseBody.byteStream();
            return stream;
        }
        String responseContent = responseBody.string();
        responseBody.close();
        if (responseContent.length() <= 0) {
            return null;
        }
        return this.mapperAdapter.deserialize(responseContent, type);
    }
}

