/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import com.microsoft.rest.DateTimeRfc1123;
import com.microsoft.rest.ServiceCallback;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.Period;

public final class Validator {
    private Validator() {
    }

    public static void validate(Object parameter) throws IllegalArgumentException {
        if (parameter == null) {
            return;
        }
        Class<?> parameterType = parameter.getClass();
        TypeToken parameterToken = TypeToken.of(parameterType);
        if (Primitives.isWrapperType(parameterType)) {
            parameterToken = parameterToken.unwrap();
        }
        if (parameterToken.isPrimitive() || parameterType.isEnum() || parameterToken.isAssignableFrom(LocalDate.class) || parameterToken.isAssignableFrom(DateTime.class) || parameterToken.isAssignableFrom(String.class) || parameterToken.isAssignableFrom(DateTimeRfc1123.class) || parameterToken.isAssignableFrom(Period.class)) {
            return;
        }
        for (Class c : parameterToken.getTypes().classes().rawTypes()) {
            if (c.isAssignableFrom(Object.class)) continue;
            for (Field field : c.getDeclaredFields()) {
                Object property;
                field.setAccessible(true);
                int mod = field.getModifiers();
                if (Modifier.isFinal(mod) || Modifier.isStatic(mod)) {
                    return;
                }
                JsonProperty annotation = field.getAnnotation(JsonProperty.class);
                try {
                    property = field.get(parameter);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
                if (property == null) {
                    if (annotation == null || !annotation.required()) continue;
                    throw new IllegalArgumentException(field.getName() + " is required and cannot be null.");
                }
                try {
                    Class<?> propertyType = property.getClass();
                    if (TypeToken.of(List.class).isAssignableFrom(propertyType)) {
                        List items = (List)property;
                        for (Object e : items) {
                            Validator.validate(e);
                        }
                        continue;
                    }
                    if (TypeToken.of(Map.class).isAssignableFrom(propertyType)) {
                        Map entries = (Map)property;
                        for (Map.Entry entry : entries.entrySet()) {
                            Validator.validate(entry.getKey());
                            Validator.validate(entry.getValue());
                        }
                        continue;
                    }
                    if (parameterType == propertyType) continue;
                    Validator.validate(property);
                }
                catch (IllegalArgumentException ex) {
                    if (ex.getCause() == null) {
                        throw new IllegalArgumentException(field.getName() + "." + ex.getMessage());
                    }
                    throw ex;
                }
            }
        }
    }

    public static void validate(Object parameter, ServiceCallback<?> serviceCallback) {
        try {
            Validator.validate(parameter);
        }
        catch (IllegalArgumentException ex) {
            serviceCallback.failure(ex);
        }
    }
}

