/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.credentials;

import com.microsoft.rest.credentials.TokenCredentials;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class TokenCredentialsInterceptor
implements Interceptor {
    private TokenCredentials credentials;

    public TokenCredentialsInterceptor(TokenCredentials credentials) {
        this.credentials = credentials;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response = this.sendRequestWithAuthorization(chain);
        if (response == null || response.code() == 401) {
            this.credentials.refreshToken();
            response = this.sendRequestWithAuthorization(chain);
        }
        return response;
    }

    private Response sendRequestWithAuthorization(Interceptor.Chain chain) throws IOException {
        Request newRequest = chain.request().newBuilder().header("Authorization", this.credentials.getScheme() + " " + this.credentials.getToken()).build();
        return chain.proceed(newRequest);
    }
}

