/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.retry;

import com.microsoft.rest.retry.ExponentialBackoffRetryStrategy;
import com.microsoft.rest.retry.RetryStrategy;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class RetryHandler
implements Interceptor {
    private static final int DEFAULT_NUMBER_OF_ATTEMPTS = 3;
    private static final int DEFAULT_BACKOFF_DELTA = 10000;
    private static final int DEFAULT_MAX_BACKOFF = 10000;
    private static final int DEFAULT_MIN_BACKOFF = 1000;
    private RetryStrategy retryStrategy;

    public RetryHandler() {
        this.retryStrategy = new ExponentialBackoffRetryStrategy(3, 1000, 10000, 10000);
    }

    public RetryHandler(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        int tryCount = 0;
        while (this.retryStrategy.shouldRetry(tryCount, response)) {
            ++tryCount;
            if (response.body() != null) {
                response.body().close();
            }
            response = chain.proceed(request);
        }
        return response;
    }
}

