/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.serializer;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.microsoft.rest.serializer.Base64UrlSerializer;
import com.microsoft.rest.serializer.ByteArraySerializer;
import com.microsoft.rest.serializer.CollectionFormat;
import com.microsoft.rest.serializer.DateTimeRfc1123Serializer;
import com.microsoft.rest.serializer.DateTimeSerializer;
import com.microsoft.rest.serializer.FlatteningDeserializer;
import com.microsoft.rest.serializer.FlatteningSerializer;
import com.microsoft.rest.serializer.HeadersSerializer;
import com.microsoft.rest.serializer.JacksonConverterFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class JacksonMapperAdapter {
    private ObjectMapper mapper;
    private ObjectMapper simpleMapper;
    private JacksonConverterFactory converterFactory;

    protected void initializeObjectMapper(ObjectMapper mapper) {
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true).setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule((Module)new JodaModule()).registerModule((Module)ByteArraySerializer.getModule()).registerModule((Module)Base64UrlSerializer.getModule()).registerModule((Module)DateTimeSerializer.getModule()).registerModule((Module)DateTimeRfc1123Serializer.getModule()).registerModule((Module)HeadersSerializer.getModule());
        mapper.setVisibility(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE));
    }

    protected ObjectMapper getSimpleMapper() {
        if (this.simpleMapper == null) {
            this.simpleMapper = new ObjectMapper();
            this.initializeObjectMapper(this.simpleMapper);
        }
        return this.simpleMapper;
    }

    public ObjectMapper getObjectMapper() {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
            this.initializeObjectMapper(this.mapper);
            this.mapper.registerModule((Module)FlatteningSerializer.getModule(this.getSimpleMapper())).registerModule((Module)FlatteningDeserializer.getModule(this.getSimpleMapper()));
        }
        return this.mapper;
    }

    public JacksonConverterFactory getConverterFactory() {
        if (this.converterFactory == null) {
            this.converterFactory = JacksonConverterFactory.create(this.getObjectMapper());
        }
        return this.converterFactory;
    }

    public String serialize(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        this.getObjectMapper().writeValue((Writer)writer, object);
        return writer.toString();
    }

    public String serializeRaw(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return CharMatcher.is((char)'\"').trimFrom((CharSequence)this.serialize(object));
        }
        catch (IOException ex) {
            return null;
        }
    }

    public String serializeList(List<?> list, CollectionFormat format) {
        if (list == null) {
            return null;
        }
        ArrayList<String> serialized = new ArrayList<String>();
        for (Object element : list) {
            String raw = this.serializeRaw(element);
            serialized.add(raw != null ? raw : "");
        }
        return Joiner.on((String)format.getDelimiter()).join(serialized);
    }

    public <T> T deserialize(String value, final Type type) throws IOException {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return (T)this.getObjectMapper().readValue(value, new TypeReference<T>(){

            public Type getType() {
                return type;
            }
        });
    }
}

