/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import com.microsoft.rest.DateTimeRfc1123;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.Period;

public final class Validator {
    private Validator() {
    }

    public static void validate(Object parameter) {
        if (parameter == null) {
            return;
        }
        Class<?> parameterType = parameter.getClass();
        TypeToken parameterToken = TypeToken.of(parameterType);
        if (Primitives.isWrapperType(parameterType)) {
            parameterToken = parameterToken.unwrap();
        }
        if (parameterToken.isPrimitive() || parameterType.isEnum() || parameterType == Class.class || parameterToken.isSupertypeOf(LocalDate.class) || parameterToken.isSupertypeOf(DateTime.class) || parameterToken.isSupertypeOf(String.class) || parameterToken.isSupertypeOf(DateTimeRfc1123.class) || parameterToken.isSupertypeOf(Period.class)) {
            return;
        }
        for (Class c : parameterToken.getTypes().classes().rawTypes()) {
            if (c.isAssignableFrom(Object.class)) continue;
            for (Field field : c.getDeclaredFields()) {
                Object property;
                JsonProperty annotation;
                field.setAccessible(true);
                int mod = field.getModifiers();
                if (Modifier.isFinal(mod) || Modifier.isStatic(mod) || (annotation = field.getAnnotation(JsonProperty.class)) != null && annotation.access().equals((Object)JsonProperty.Access.WRITE_ONLY)) continue;
                try {
                    property = field.get(parameter);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
                if (property == null) {
                    if (annotation == null || !annotation.required()) continue;
                    throw new IllegalArgumentException(field.getName() + " is required and cannot be null.");
                }
                try {
                    Class<?> propertyType = property.getClass();
                    if (TypeToken.of(List.class).isSupertypeOf(propertyType)) {
                        List items = (List)property;
                        for (Object e : items) {
                            Validator.validate(e);
                        }
                        continue;
                    }
                    if (TypeToken.of(Map.class).isSupertypeOf(propertyType)) {
                        Map entries = (Map)property;
                        for (Map.Entry entry : entries.entrySet()) {
                            Validator.validate(entry.getKey());
                            Validator.validate(entry.getValue());
                        }
                        continue;
                    }
                    if (parameterType == propertyType) continue;
                    Validator.validate(property);
                }
                catch (IllegalArgumentException ex) {
                    if (ex.getCause() == null) {
                        throw new IllegalArgumentException(field.getName() + "." + ex.getMessage());
                    }
                    throw ex;
                }
            }
        }
    }
}

