/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.collect.Sets;
import com.microsoft.rest.DateTimeRfc1123;
import com.microsoft.rest.serializer.JsonFlatten;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.Period;

public class FlatteningSerializer
extends StdSerializer<Object>
implements ResolvableSerializer {
    private final JsonSerializer<?> defaultSerializer;
    private final ObjectMapper mapper;

    protected FlatteningSerializer(Class<?> vc, JsonSerializer<?> defaultSerializer, ObjectMapper mapper) {
        super(vc, false);
        this.defaultSerializer = defaultSerializer;
        this.mapper = mapper;
    }

    public static SimpleModule getModule(final ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.setSerializerModifier(new BeanSerializerModifier(){

            public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                if (beanDesc.getBeanClass().getAnnotation(JsonFlatten.class) != null) {
                    return new FlatteningSerializer(beanDesc.getBeanClass(), serializer, mapper);
                }
                return serializer;
            }
        });
        return module;
    }

    private List<Field> getAllDeclaredFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null && !clazz.equals(Object.class)) {
            for (Field f : clazz.getDeclaredFields()) {
                int mod = f.getModifiers();
                if (Modifier.isFinal(mod) || Modifier.isStatic(mod)) continue;
                fields.add(f);
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    private void escapeMapKeys(Object value) {
        if (value == null) {
            return;
        }
        if (value.getClass().isPrimitive() || value.getClass().isEnum() || value instanceof LocalDate || value instanceof DateTime || value instanceof String || value instanceof DateTimeRfc1123 || value instanceof Period) {
            return;
        }
        int mod = value.getClass().getModifiers();
        if (Modifier.isFinal(mod) || Modifier.isStatic(mod)) {
            return;
        }
        if (value instanceof List) {
            for (Object val : (List)value) {
                this.escapeMapKeys(val);
            }
            return;
        }
        if (value instanceof Map) {
            for (String key : Sets.newHashSet(((Map)value).keySet())) {
                if (!key.contains(".")) continue;
                String newKey = key.replaceAll("((?<!\\\\))\\.", "\\.");
                Object val = ((Map)value).remove(key);
                ((Map)value).put(newKey, val);
            }
            for (Object val : ((Map)value).values()) {
                this.escapeMapKeys(val);
            }
            return;
        }
        for (Field f : this.getAllDeclaredFields(value.getClass())) {
            f.setAccessible(true);
            try {
                this.escapeMapKeys(f.get(value));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value == null) {
            jgen.writeNull();
            return;
        }
        this.escapeMapKeys(value);
        ObjectNode root = (ObjectNode)this.mapper.valueToTree(value);
        ObjectNode res = root.deepCopy();
        LinkedBlockingQueue<ObjectNode> source = new LinkedBlockingQueue<ObjectNode>();
        LinkedBlockingQueue<ObjectNode> target = new LinkedBlockingQueue<ObjectNode>();
        source.add(root);
        target.add(res);
        while (!source.isEmpty()) {
            ObjectNode current = (ObjectNode)source.poll();
            ObjectNode resCurrent = (ObjectNode)target.poll();
            Iterator fields = current.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                ObjectNode node = resCurrent;
                String key = (String)field.getKey();
                JsonNode outNode = resCurrent.get(key);
                if (((String)field.getKey()).matches(".+[^\\\\]\\..+")) {
                    String[] values = ((String)field.getKey()).split("((?<!\\\\))\\.");
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = values[i].replace("\\.", ".");
                        if (i == values.length - 1) break;
                        String val = values[i];
                        if (node.has(val)) {
                            node = (ObjectNode)node.get(val);
                            continue;
                        }
                        ObjectNode child = new ObjectNode(JsonNodeFactory.instance);
                        node.put(val, (JsonNode)child);
                        node = child;
                    }
                    node.set(values[values.length - 1], resCurrent.get((String)field.getKey()));
                    resCurrent.remove((String)field.getKey());
                    outNode = node.get(values[values.length - 1]);
                }
                if (field.getValue() instanceof ObjectNode) {
                    source.add((ObjectNode)field.getValue());
                    target.add((ObjectNode)outNode);
                    continue;
                }
                if (!(field.getValue() instanceof ArrayNode) || ((JsonNode)field.getValue()).size() <= 0 || !(((JsonNode)field.getValue()).get(0) instanceof ObjectNode)) continue;
                Iterator sourceIt = ((JsonNode)field.getValue()).elements();
                Iterator targetIt = outNode.elements();
                while (sourceIt.hasNext()) {
                    source.add((ObjectNode)sourceIt.next());
                    target.add((ObjectNode)targetIt.next());
                }
            }
        }
        jgen.writeTree((TreeNode)res);
    }

    public void resolve(SerializerProvider provider) throws JsonMappingException {
        ((ResolvableSerializer)this.defaultSerializer).resolve(provider);
    }

    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSerializer) throws IOException {
        this.serialize(value, gen, provider);
    }
}

