/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest;

import com.google.common.util.concurrent.AbstractFuture;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseWithHeaders;
import rx.Completable;
import rx.Observable;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;

public class ServiceFuture<T>
extends AbstractFuture<T> {
    private Subscription subscription;

    protected ServiceFuture() {
    }

    public static <T> ServiceFuture<T> fromResponse(Observable<ServiceResponse<T>> observable) {
        ServiceFuture<T> serviceFuture = new ServiceFuture<T>();
        serviceFuture.subscription = observable.last().subscribe(new Action1<ServiceResponse<T>>(){

            public void call(ServiceResponse<T> t) {
                ServiceFuture.this.set(t.body());
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                ServiceFuture.this.setException(throwable);
            }
        });
        return serviceFuture;
    }

    public static <T> ServiceFuture<T> fromResponse(Observable<ServiceResponse<T>> observable, final ServiceCallback<T> callback) {
        final ServiceFuture<T> serviceFuture = new ServiceFuture<T>();
        serviceFuture.subscription = observable.last().subscribe(new Action1<ServiceResponse<T>>(){

            public void call(ServiceResponse<T> t) {
                if (callback != null) {
                    callback.success(t.body());
                }
                serviceFuture.set(t.body());
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                if (callback != null) {
                    callback.failure(throwable);
                }
                serviceFuture.setException(throwable);
            }
        });
        return serviceFuture;
    }

    public static <T> ServiceFuture<T> fromBody(Observable<T> observable, final ServiceCallback<T> callback) {
        final ServiceFuture<T> serviceFuture = new ServiceFuture<T>();
        serviceFuture.subscription = observable.last().subscribe(new Action1<T>(){

            public void call(T t) {
                if (callback != null) {
                    callback.success(t);
                }
                serviceFuture.set(t);
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                if (callback != null) {
                    callback.failure(throwable);
                }
                serviceFuture.setException(throwable);
            }
        });
        return serviceFuture;
    }

    public static ServiceFuture<Void> fromBody(Completable completable, final ServiceCallback<Void> callback) {
        final ServiceFuture<Void> serviceFuture = new ServiceFuture<Void>();
        completable.subscribe(new Action0(){
            Void value = null;

            public void call() {
                if (callback != null) {
                    callback.success(this.value);
                }
                serviceFuture.set(this.value);
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                if (callback != null) {
                    callback.failure(throwable);
                }
                serviceFuture.setException(throwable);
            }
        });
        return serviceFuture;
    }

    public static <T, V> ServiceFuture<T> fromHeaderResponse(Observable<ServiceResponseWithHeaders<T, V>> observable, final ServiceCallback<T> callback) {
        final ServiceFuture<T> serviceFuture = new ServiceFuture<T>();
        serviceFuture.subscription = observable.last().subscribe(new Action1<ServiceResponse<T>>(){

            public void call(ServiceResponse<T> t) {
                if (callback != null) {
                    callback.success(t.body());
                }
                serviceFuture.set(t.body());
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                if (callback != null) {
                    callback.failure(throwable);
                }
                serviceFuture.setException(throwable);
            }
        });
        return serviceFuture;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    protected void setSubscription(Subscription subscription) {
        this.subscription = subscription;
    }

    public boolean success(T result) {
        return this.set(result);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        this.subscription.unsubscribe();
        return super.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.subscription.isUnsubscribed();
    }
}

