/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.aiservices.openai.chatcompletion;

import com.azure.ai.openai.OpenAIAsyncClient;
import com.azure.ai.openai.models.ChatChoice;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsFunctionToolCall;
import com.azure.ai.openai.models.ChatCompletionsFunctionToolDefinition;
import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.ChatRequestAssistantMessage;
import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.ChatRequestSystemMessage;
import com.azure.ai.openai.models.ChatRequestToolMessage;
import com.azure.ai.openai.models.ChatRequestUserMessage;
import com.azure.ai.openai.models.ChatResponseMessage;
import com.azure.ai.openai.models.CompletionsUsage;
import com.azure.core.util.BinaryData;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.semantickernel.Kernel;
import com.microsoft.semantickernel.aiservices.openai.chatcompletion.OpenAIFunction;
import com.microsoft.semantickernel.aiservices.openai.chatcompletion.ParsedPrompt;
import com.microsoft.semantickernel.aiservices.openai.chatcompletion.XMLPromptParser;
import com.microsoft.semantickernel.contextvariables.ContextVariable;
import com.microsoft.semantickernel.contextvariables.ContextVariableTypes;
import com.microsoft.semantickernel.exceptions.AIException;
import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.hooks.KernelHookEvent;
import com.microsoft.semantickernel.hooks.KernelHooks;
import com.microsoft.semantickernel.hooks.PreChatCompletionEvent;
import com.microsoft.semantickernel.orchestration.FunctionResult;
import com.microsoft.semantickernel.orchestration.FunctionResultMetadata;
import com.microsoft.semantickernel.orchestration.InvocationContext;
import com.microsoft.semantickernel.orchestration.PromptExecutionSettings;
import com.microsoft.semantickernel.orchestration.ToolCallBehavior;
import com.microsoft.semantickernel.semanticfunctions.KernelFunction;
import com.microsoft.semantickernel.semanticfunctions.KernelFunctionArguments;
import com.microsoft.semantickernel.services.chatcompletion.AuthorRole;
import com.microsoft.semantickernel.services.chatcompletion.ChatCompletionService;
import com.microsoft.semantickernel.services.chatcompletion.ChatHistory;
import com.microsoft.semantickernel.services.chatcompletion.ChatMessageContent;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class OpenAIChatCompletion
implements ChatCompletionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAIChatCompletion.class);
    private final OpenAIAsyncClient client;
    @Nullable
    private final String serviceId;
    private final String modelId;

    protected OpenAIChatCompletion(OpenAIAsyncClient client, String modelId, @Nullable String serviceId) {
        this.serviceId = serviceId;
        this.client = client;
        this.modelId = modelId;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public String getServiceId() {
        return this.serviceId;
    }

    public Mono<List<ChatMessageContent<?>>> getChatMessageContentsAsync(ChatHistory chatHistory, @Nullable Kernel kernel, @Nullable InvocationContext invocationContext) {
        List<ChatRequestMessage> chatRequestMessages = OpenAIChatCompletion.getChatRequestMessages(chatHistory);
        return this.internalChatMessageContentsAsync(chatRequestMessages, kernel, invocationContext);
    }

    public Mono<List<ChatMessageContent<?>>> getChatMessageContentsAsync(String prompt, @Nullable Kernel kernel, @Nullable InvocationContext invocationContext) {
        ParsedPrompt parsedPrompt = XMLPromptParser.parse(prompt);
        return this.internalChatMessageContentsAsync(parsedPrompt.getChatRequestMessages(), kernel, invocationContext);
    }

    private Mono<List<ChatMessageContent<?>>> internalChatMessageContentsAsync(List<ChatRequestMessage> messages, @Nullable Kernel kernel, @Nullable InvocationContext invocationContext) {
        ArrayList<OpenAIFunction> functions = new ArrayList<OpenAIFunction>();
        if (kernel != null) {
            kernel.getPlugins().forEach(plugin -> plugin.getFunctions().forEach((name, function) -> functions.add(OpenAIFunction.build(function.getMetadata(), plugin.getName()))));
        }
        return this.internalChatMessageContentsAsync(new ArrayList<ChatRequestMessage>(messages), kernel, functions, invocationContext, Math.min(5, invocationContext != null && invocationContext.getToolCallBehavior() != null ? invocationContext.getToolCallBehavior().getMaximumAutoInvokeAttempts() : 0));
    }

    private Mono<List<ChatMessageContent<?>>> internalChatMessageContentsAsync(List<ChatRequestMessage> messages, @Nullable Kernel kernel, List<OpenAIFunction> functions, @Nullable InvocationContext invocationContext, int autoInvokeAttempts) {
        KernelHooks kernelHooks = invocationContext != null && invocationContext.getKernelHooks() != null ? invocationContext.getKernelHooks() : new KernelHooks();
        ChatCompletionsOptions options = ((PreChatCompletionEvent)kernelHooks.executeHooks((KernelHookEvent)new PreChatCompletionEvent(OpenAIChatCompletion.getCompletionsOptions(this, messages, functions, invocationContext, autoInvokeAttempts)))).getOptions();
        Mono result = this.client.getChatCompletions(this.getModelId(), options).flatMap(completions -> {
            List responseMessages = completions.getChoices().stream().map(ChatChoice::getMessage).filter(Objects::nonNull).collect(Collectors.toList());
            if (autoInvokeAttempts == 0 || responseMessages.size() != 1) {
                return this.getChatMessageContentsAsync((ChatCompletions)completions);
            }
            ChatResponseMessage response = (ChatResponseMessage)responseMessages.get(0);
            List toolCalls = response.getToolCalls();
            if (toolCalls == null || toolCalls.isEmpty()) {
                return this.getChatMessageContentsAsync((ChatCompletions)completions);
            }
            ChatRequestAssistantMessage requestMessage = new ChatRequestAssistantMessage(response.getContent());
            requestMessage.setToolCalls(toolCalls);
            messages.add((ChatRequestMessage)requestMessage);
            return Flux.fromIterable((Iterable)toolCalls).reduce((Object)Mono.just((Object)messages), (requestMessages, toolCall) -> {
                if (toolCall instanceof ChatCompletionsFunctionToolCall) {
                    return requestMessages.flatMap(msgs -> {
                        ChatCompletionsFunctionToolCall functionToolCall = (ChatCompletionsFunctionToolCall)toolCall;
                        if (kernel == null) {
                            return Mono.error((Throwable)new SKException("A tool call was requested, but no kernel was provided to the invocation, this is a unsupported configuration"));
                        }
                        return this.invokeFunctionTool(kernel, functionToolCall).map(functionResult -> {
                            ChatRequestToolMessage requestToolMessage = new ChatRequestToolMessage((String)functionResult.getResult(), functionToolCall.getId());
                            msgs.add(requestToolMessage);
                            return msgs;
                        });
                    });
                }
                return requestMessages;
            }).flatMap(it -> it).flatMap(msgs -> this.internalChatMessageContentsAsync((List<ChatRequestMessage>)msgs, kernel, functions, invocationContext, autoInvokeAttempts - 1));
        });
        return result.map(op -> op);
    }

    private Mono<FunctionResult<String>> invokeFunctionTool(Kernel kernel, ChatCompletionsFunctionToolCall toolCall) {
        String name = toolCall.getFunction().getName();
        String[] parts = name.split(OpenAIFunction.getNameSeparator());
        String pluginName = parts.length > 1 ? parts[0] : "";
        String fnName = parts.length > 1 ? parts[1] : parts[0];
        KernelFunction function = kernel.getFunction(pluginName, fnName);
        KernelFunctionArguments arguments = KernelFunctionArguments.builder().build();
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonToolCallArguments = mapper.readTree(toolCall.getFunction().getArguments());
            jsonToolCallArguments.fields().forEachRemaining(entry -> arguments.put((String)entry.getKey(), ContextVariable.of((String)((JsonNode)entry.getValue()).asText())));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to parse json", (Throwable)e);
            return Mono.empty();
        }
        return function.invokeAsync(kernel).withArguments(arguments).withResultType(ContextVariableTypes.getGlobalVariableTypeForClass(String.class));
    }

    private Mono<List<ChatMessageContent>> getChatMessageContentsAsync(ChatCompletions completions) {
        FunctionResultMetadata completionMetadata = FunctionResultMetadata.build((String)completions.getId(), (CompletionsUsage)completions.getUsage(), (OffsetDateTime)completions.getCreatedAt());
        List responseMessages = completions.getChoices().stream().map(ChatChoice::getMessage).filter(Objects::nonNull).collect(Collectors.toList());
        return Flux.fromIterable(responseMessages).map(response -> new ChatMessageContent(AuthorRole.ASSISTANT, response.getContent(), this.getModelId(), null, null, completionMetadata)).collectList();
    }

    private static ChatCompletionsOptions getCompletionsOptions(ChatCompletionService chatCompletionService, List<ChatRequestMessage> chatRequestMessages, @Nullable List<OpenAIFunction> functions, @Nullable InvocationContext invocationContext, int autoInvokeAttempts) {
        PromptExecutionSettings promptExecutionSettings;
        ChatCompletionsOptions options = new ChatCompletionsOptions(chatRequestMessages).setModel(chatCompletionService.getModelId());
        if (invocationContext != null && invocationContext.getToolCallBehavior() != null) {
            OpenAIChatCompletion.configureToolCallBehaviorOptions(options, invocationContext.getToolCallBehavior(), functions, autoInvokeAttempts);
        }
        PromptExecutionSettings promptExecutionSettings2 = promptExecutionSettings = invocationContext != null ? invocationContext.getPromptExecutionSettings() : null;
        if (promptExecutionSettings == null) {
            return options;
        }
        if (promptExecutionSettings.getResultsPerPrompt() < 1 || promptExecutionSettings.getResultsPerPrompt() > 128) {
            throw new AIException(AIException.ErrorCodes.INVALID_REQUEST, String.format("Results per prompt must be in range between 1 and %d, inclusive.", 128));
        }
        Map<String, Integer> logit = null;
        if (promptExecutionSettings.getTokenSelectionBiases() != null) {
            logit = promptExecutionSettings.getTokenSelectionBiases().entrySet().stream().collect(Collectors.toMap(entry -> ((Integer)entry.getKey()).toString(), Map.Entry::getValue));
        }
        options.setTemperature(Double.valueOf(promptExecutionSettings.getTemperature())).setTopP(Double.valueOf(promptExecutionSettings.getTopP())).setPresencePenalty(Double.valueOf(promptExecutionSettings.getPresencePenalty())).setFrequencyPenalty(Double.valueOf(promptExecutionSettings.getFrequencyPenalty())).setPresencePenalty(Double.valueOf(promptExecutionSettings.getPresencePenalty())).setMaxTokens(Integer.valueOf(promptExecutionSettings.getMaxTokens())).setN(Integer.valueOf(promptExecutionSettings.getResultsPerPrompt())).setStop(promptExecutionSettings.getStopSequences() == null || promptExecutionSettings.getStopSequences().isEmpty() ? null : promptExecutionSettings.getStopSequences()).setUser(promptExecutionSettings.getUser()).setLogitBias(logit);
        return options;
    }

    private static void configureToolCallBehaviorOptions(ChatCompletionsOptions options, @Nullable ToolCallBehavior toolCallBehavior, @Nullable List<OpenAIFunction> functions, int autoInvokeAttempts) {
        if (functions == null || functions.isEmpty()) {
            return;
        }
        if (toolCallBehavior == null || autoInvokeAttempts == 0) {
            return;
        }
        if (toolCallBehavior instanceof ToolCallBehavior.RequiredKernelFunction) {
            KernelFunction toolChoice = ((ToolCallBehavior.RequiredKernelFunction)toolCallBehavior).getRequiredFunction();
            ArrayList<ChatCompletionsFunctionToolDefinition> toolDefinitions = new ArrayList<ChatCompletionsFunctionToolDefinition>();
            toolDefinitions.add(new ChatCompletionsFunctionToolDefinition(OpenAIFunction.toFunctionDefinition(toolChoice.getMetadata(), toolChoice.getPluginName())));
            options.setTools(toolDefinitions);
            try {
                String json = String.format("{\"type\":\"function\",\"function\":{\"name\":\"%s%s%s\"}}", toolChoice.getPluginName(), OpenAIFunction.getNameSeparator(), toolChoice.getName());
                options.setToolChoice(BinaryData.fromObject((Object)new ObjectMapper().readTree(json)));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        ToolCallBehavior.AllowedKernelFunctions enabledKernelFunctions = (ToolCallBehavior.AllowedKernelFunctions)toolCallBehavior;
        List toolDefinitions = functions.stream().filter(function -> {
            if (enabledKernelFunctions.isAllKernelFunctionsAllowed()) {
                return true;
            }
            return enabledKernelFunctions.isFunctionAllowed(function.getPluginName(), function.getName());
        }).map(OpenAIFunction::getFunctionDefinition).map(ChatCompletionsFunctionToolDefinition::new).collect(Collectors.toList());
        if (toolDefinitions.isEmpty()) {
            return;
        }
        options.setTools(toolDefinitions);
        options.setToolChoice(BinaryData.fromString((String)"auto"));
    }

    private static List<ChatRequestMessage> getChatRequestMessages(ChatHistory chatHistory) {
        List messages = chatHistory.getMessages();
        if (messages == null || messages.isEmpty()) {
            return new ArrayList<ChatRequestMessage>();
        }
        return messages.stream().map(message -> {
            AuthorRole authorRole = message.getAuthorRole();
            String content = message.getContent();
            return OpenAIChatCompletion.getChatRequestMessage(authorRole, content);
        }).collect(Collectors.toList());
    }

    static ChatRequestMessage getChatRequestMessage(AuthorRole authorRole, @Nullable String content) {
        switch (authorRole) {
            case ASSISTANT: {
                return new ChatRequestAssistantMessage(content);
            }
            case SYSTEM: {
                return new ChatRequestSystemMessage(content);
            }
            case USER: {
                return new ChatRequestUserMessage(content);
            }
            case TOOL: {
                return new ChatRequestToolMessage(content, null);
            }
        }
        LOGGER.debug("Unexpected author role: " + authorRole);
        throw new SKException("Unexpected author role: " + authorRole);
    }

    @Nullable
    public String getModelId() {
        return this.modelId;
    }

    public static class Builder
    extends ChatCompletionService.Builder {
        public OpenAIChatCompletion build() {
            if (this.client == null) {
                throw new AIException(AIException.ErrorCodes.INVALID_REQUEST, "OpenAI client must be provided");
            }
            if (this.modelId == null || this.modelId.isEmpty()) {
                throw new AIException(AIException.ErrorCodes.INVALID_REQUEST, "OpenAI model id must be provided");
            }
            return new OpenAIChatCompletion(this.client, this.modelId, this.serviceId);
        }
    }
}

