/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.aiservices.openai.chatcompletion;

import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.ChatRequestUserMessage;
import com.azure.ai.openai.models.FunctionDefinition;
import com.azure.core.util.BinaryData;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.semantickernel.aiservices.openai.chatcompletion.OpenAIChatCompletion;
import com.microsoft.semantickernel.aiservices.openai.chatcompletion.ParsedPrompt;
import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.orchestration.ToolCallBehavior;
import com.microsoft.semantickernel.services.chatcompletion.AuthorRole;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XMLPromptParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLPromptParser.class);

    XMLPromptParser() {
    }

    public static ParsedPrompt parse(String rawPrompt) {
        List<String> prompts = Arrays.asList(rawPrompt, "<prompt>" + rawPrompt + "</prompt>");
        for (String prompt : prompts) {
            try {
                List<ChatRequestMessage> parsedMessages = XMLPromptParser.getChatRequestMessages(prompt);
                List<FunctionDefinition> parsedFunctions = XMLPromptParser.getFunctionDefinitions(prompt);
                if (parsedMessages.isEmpty()) continue;
                return new ParsedPrompt(parsedMessages, parsedFunctions);
            }
            catch (SKException sKException) {
            }
        }
        return new ParsedPrompt(Collections.singletonList(new ChatRequestUserMessage(rawPrompt)), null);
    }

    private static List<ChatRequestMessage> getChatRequestMessages(String prompt) {
        ArrayList<ChatRequestMessage> messages = new ArrayList<ChatRequestMessage>();
        try (ByteArrayInputStream is = new ByteArrayInputStream(prompt.getBytes(StandardCharsets.UTF_8));){
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLEventReader reader = factory.createXMLEventReader(is);
            while (reader.hasNext()) {
                String name;
                XMLEvent event = reader.nextEvent();
                if (!event.isStartElement() || !(name = XMLPromptParser.getElementName(event)).equals("message")) continue;
                String role = XMLPromptParser.getAttributeValue(event, "role");
                String content = reader.getElementText();
                messages.add(XMLPromptParser.getChatRequestMessage(role, content));
            }
        }
        catch (IOException | IllegalArgumentException | XMLStreamException e) {
            throw new SKException("Failed to parse messages");
        }
        return messages;
    }

    private static List<FunctionDefinition> getFunctionDefinitions(String prompt) {
        ArrayList<FunctionDefinition> functionDefinitions = new ArrayList<FunctionDefinition>();
        try (ByteArrayInputStream is = new ByteArrayInputStream(prompt.getBytes(StandardCharsets.UTF_8));){
            XMLInputFactory factory = XMLInputFactory.newFactory();
            XMLEventReader reader = factory.createXMLEventReader(is);
            FunctionDefinition functionDefinition = null;
            HashMap<String, String> parameters = new HashMap<String, String>();
            ArrayList<String> requiredParmeters = new ArrayList<String>();
            while (reader.hasNext()) {
                String elementName;
                XMLEvent event = reader.nextEvent();
                if (event.isStartElement()) {
                    String description;
                    elementName = XMLPromptParser.getElementName(event);
                    if (elementName.equals("function")) {
                        assert (functionDefinition == null);
                        assert (parameters.isEmpty());
                        assert (requiredParmeters.isEmpty());
                        String pluginName = XMLPromptParser.getAttributeValue(event, "pluginName");
                        String name2 = XMLPromptParser.getAttributeValue(event, "name");
                        description = XMLPromptParser.getAttributeValue(event, "description");
                        functionDefinition = new FunctionDefinition(ToolCallBehavior.formFullFunctionName((String)pluginName, (String)name2)).setDescription(description);
                        continue;
                    }
                    if (!elementName.equals("parameter")) continue;
                    String name3 = XMLPromptParser.getAttributeValue(event, "name");
                    String type = XMLPromptParser.getAttributeValue(event, "type").toLowerCase(Locale.ROOT);
                    description = XMLPromptParser.getAttributeValue(event, "description");
                    parameters.put(name3, String.format("{\"type\": \"%s\", \"description\": \"%s\"}", "string", description));
                    String isRequired = XMLPromptParser.getAttributeValue(event, "isRequired");
                    if (!Boolean.parseBoolean(isRequired)) continue;
                    requiredParmeters.add(name3);
                    continue;
                }
                if (!event.isEndElement() || !(elementName = XMLPromptParser.getElementName(event)).equals("function")) continue;
                if (functionDefinition == null) {
                    throw new SKException("Failed to parse function definition");
                }
                if (!parameters.isEmpty()) {
                    StringBuilder sb = new StringBuilder("{\"type\": \"object\", \"properties\": {");
                    parameters.forEach((name, value) -> sb.append(String.format("\"%s\": %s,", name, value)));
                    sb.replace(sb.length() - 1, sb.length(), "}");
                    if (!requiredParmeters.isEmpty()) {
                        sb.append(", \"required\": [");
                        requiredParmeters.forEach(name -> sb.append(String.format("\"%s\",", name)));
                        sb.replace(sb.length() - 1, sb.length(), "]");
                    }
                    sb.append("}");
                    ObjectMapper objectMapper = new ObjectMapper();
                    JsonNode jsonNode = objectMapper.readTree(sb.toString());
                    BinaryData binaryData = BinaryData.fromObject((Object)jsonNode);
                    functionDefinition.setParameters(binaryData);
                }
                functionDefinitions.add(functionDefinition);
                functionDefinition = null;
                parameters.clear();
                requiredParmeters.clear();
            }
        }
        catch (IOException | IllegalArgumentException | XMLStreamException e) {
            LOGGER.error("Error parsing prompt", (Throwable)e);
        }
        return functionDefinitions;
    }

    private static String getElementName(XMLEvent xmlEvent) {
        if (xmlEvent.isStartElement()) {
            return xmlEvent.asStartElement().getName().getLocalPart();
        }
        if (xmlEvent.isEndElement()) {
            return xmlEvent.asEndElement().getName().getLocalPart();
        }
        return "";
    }

    private static String getAttributeValue(XMLEvent xmlEvent, String attributeName) {
        if (xmlEvent.isStartElement()) {
            StartElement element = xmlEvent.asStartElement();
            Attribute attribute = element.getAttributeByName(QName.valueOf(attributeName));
            return attribute != null ? attribute.getValue() : "";
        }
        return "";
    }

    private static ChatRequestMessage getChatRequestMessage(String role, String content) {
        try {
            AuthorRole authorRole = AuthorRole.valueOf((String)role.toUpperCase(Locale.ROOT));
            return OpenAIChatCompletion.getChatRequestMessage(authorRole, content);
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Unknown author role: " + role);
            throw new SKException("Unknown author role: " + role);
        }
    }
}

