/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.aiservices.openai.textcompletion;

import com.azure.ai.openai.OpenAIAsyncClient;
import com.azure.ai.openai.models.Completions;
import com.azure.ai.openai.models.CompletionsOptions;
import com.azure.ai.openai.models.CompletionsUsage;
import com.microsoft.semantickernel.Kernel;
import com.microsoft.semantickernel.aiservices.openai.OpenAIRequestSettings;
import com.microsoft.semantickernel.contextvariables.ContextVariable;
import com.microsoft.semantickernel.exceptions.AIException;
import com.microsoft.semantickernel.orchestration.FunctionResultMetadata;
import com.microsoft.semantickernel.orchestration.PromptExecutionSettings;
import com.microsoft.semantickernel.services.textcompletion.StreamingTextContent;
import com.microsoft.semantickernel.services.textcompletion.TextContent;
import com.microsoft.semantickernel.services.textcompletion.TextGenerationService;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class OpenAITextGenerationService
implements TextGenerationService {
    private final OpenAIAsyncClient client;
    @Nullable
    private final String serviceId;
    private final String modelId;

    protected OpenAITextGenerationService(OpenAIAsyncClient client, String modelId, @Nullable String serviceId) {
        this.serviceId = serviceId;
        this.client = client;
        this.modelId = modelId;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public String getServiceId() {
        return this.serviceId;
    }

    public Mono<List<TextContent>> getTextContentsAsync(String prompt, @Nullable PromptExecutionSettings executionSettings, @Nullable Kernel kernel) {
        return this.internalCompleteTextAsync(prompt, executionSettings);
    }

    public Flux<StreamingTextContent> getStreamingTextContentsAsync(String prompt, @Nullable PromptExecutionSettings executionSettings, @Nullable Kernel kernel) {
        return this.internalCompleteTextAsync(prompt, executionSettings).flatMapMany(it -> Flux.fromStream(it.stream()).map(StreamingTextContent::new));
    }

    protected Mono<List<TextContent>> internalCompleteTextAsync(String text, @Nullable PromptExecutionSettings requestSettings) {
        CompletionsOptions completionsOptions = this.getCompletionsOptions(text, requestSettings);
        return this.client.getCompletionsWithResponse(this.getModelId(), completionsOptions, OpenAIRequestSettings.getRequestOptions()).flatMap(completionsResult -> {
            if (completionsResult.getStatusCode() >= 400) {
                return Mono.error((Throwable)new AIException(AIException.ErrorCodes.SERVICE_ERROR, "Request failed: " + completionsResult.getStatusCode()));
            }
            return Mono.just((Object)((Completions)completionsResult.getValue()));
        }).map(completions -> {
            FunctionResultMetadata metadata = FunctionResultMetadata.build((String)completions.getId(), (CompletionsUsage)completions.getUsage(), (OffsetDateTime)completions.getCreatedAt());
            return completions.getChoices().stream().map(choice -> new TextContent(choice.getText(), completionsOptions.getModel(), metadata)).collect(Collectors.toList());
        });
    }

    public static Map<String, ContextVariable<?>> buildMetadata(String id, CompletionsUsage usage, OffsetDateTime createdAt) {
        HashMap metadata = new HashMap();
        metadata.put("id", ContextVariable.of((String)id));
        metadata.put("usage", ContextVariable.of((CompletionsUsage)usage));
        metadata.put("created_at", ContextVariable.of((OffsetDateTime)createdAt));
        return metadata;
    }

    private CompletionsOptions getCompletionsOptions(String text, @Nullable PromptExecutionSettings requestSettings) {
        if (requestSettings == null) {
            return new CompletionsOptions(Collections.singletonList(text)).setMaxTokens(PromptExecutionSettings.DEFAULT_MAX_TOKENS);
        }
        if (requestSettings.getMaxTokens() < 1) {
            throw new AIException(AIException.ErrorCodes.INVALID_REQUEST, "Max tokens must be >0");
        }
        if (requestSettings.getResultsPerPrompt() < 1 || requestSettings.getResultsPerPrompt() > 128) {
            throw new AIException(AIException.ErrorCodes.INVALID_REQUEST, String.format("Results per prompt must be in range between 1 and %d, inclusive.", 128));
        }
        CompletionsOptions options = new CompletionsOptions(Collections.singletonList(text)).setMaxTokens(Integer.valueOf(requestSettings.getMaxTokens())).setTemperature(Double.valueOf(requestSettings.getTemperature())).setTopP(Double.valueOf(requestSettings.getTopP())).setFrequencyPenalty(Double.valueOf(requestSettings.getFrequencyPenalty())).setPresencePenalty(Double.valueOf(requestSettings.getPresencePenalty())).setModel(this.getModelId()).setN(Integer.valueOf(requestSettings.getResultsPerPrompt())).setUser(requestSettings.getUser()).setBestOf(Integer.valueOf(requestSettings.getBestOf())).setLogitBias(new HashMap());
        return options;
    }

    @Nullable
    public String getModelId() {
        return this.modelId;
    }

    public static class Builder
    extends TextGenerationService.Builder {
        public TextGenerationService build() {
            if (this.client == null) {
                throw new AIException(AIException.ErrorCodes.INVALID_REQUEST, "OpenAI client must be provided");
            }
            if (this.modelId == null) {
                throw new AIException(AIException.ErrorCodes.INVALID_REQUEST, "OpenAI model id must be provided");
            }
            return new OpenAITextGenerationService(this.client, this.modelId, this.serviceId);
        }
    }
}

