/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.aiservices.openai.audio;

import com.azure.ai.openai.OpenAIAsyncClient;
import com.azure.ai.openai.models.AudioTranscription;
import com.azure.ai.openai.models.AudioTranscriptionFormat;
import com.azure.ai.openai.models.AudioTranscriptionOptions;
import com.microsoft.semantickernel.aiservices.openai.OpenAiService;
import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.services.audio.AudioContent;
import com.microsoft.semantickernel.services.audio.AudioToTextExecutionSettings;
import com.microsoft.semantickernel.services.audio.AudioToTextService;
import javax.annotation.Nullable;
import reactor.core.publisher.Mono;

public class OpenAiAudioToTextService
extends OpenAiService
implements AudioToTextService {
    public OpenAiAudioToTextService(OpenAIAsyncClient client, String modelId) {
        super(client, null, modelId);
    }

    public Mono<String> getTextContentsAsync(AudioContent content, @Nullable AudioToTextExecutionSettings executionSettings) {
        AudioTranscriptionOptions options = this.convertOptions(content, executionSettings);
        return this.getClient().getAudioTranscription(this.getModelId(), options.getFilename(), options).map(AudioTranscription::getText);
    }

    private AudioTranscriptionOptions convertOptions(AudioContent content, @Nullable AudioToTextExecutionSettings executionSettings) {
        AudioTranscriptionOptions options = new AudioTranscriptionOptions(content.getData());
        options.setModel(this.getModelId());
        if (executionSettings == null) {
            return options;
        }
        if (executionSettings.getResponseFormat() != null) {
            options.setResponseFormat(AudioTranscriptionFormat.fromString((String)executionSettings.getResponseFormat()));
        }
        if (executionSettings.getFilename() != null) {
            options.setFilename(executionSettings.getFilename());
        }
        if (executionSettings.getLanguage() != null) {
            options.setLanguage(executionSettings.getLanguage());
        }
        if (executionSettings.getPrompt() != null) {
            options.setPrompt(executionSettings.getPrompt());
        }
        if (executionSettings.getTemperature() != null) {
            options.setTemperature(executionSettings.getTemperature());
        }
        return options;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AudioToTextService.Builder {
        public AudioToTextService build() {
            if (this.client == null) {
                throw new SKException("OpenAI client is required");
            }
            if (this.modelId == null) {
                throw new SKException("Model id is required");
            }
            return new OpenAiAudioToTextService(this.client, this.modelId);
        }
    }
}

