/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.aiservices.openai.chatcompletion;

import com.azure.ai.openai.OpenAIAsyncClient;
import com.azure.ai.openai.models.ChatChoice;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsFunctionToolCall;
import com.azure.ai.openai.models.ChatCompletionsFunctionToolDefinition;
import com.azure.ai.openai.models.ChatCompletionsJsonResponseFormat;
import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.ChatCompletionsResponseFormat;
import com.azure.ai.openai.models.ChatCompletionsTextResponseFormat;
import com.azure.ai.openai.models.ChatCompletionsToolCall;
import com.azure.ai.openai.models.ChatRequestAssistantMessage;
import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.ChatRequestSystemMessage;
import com.azure.ai.openai.models.ChatRequestToolMessage;
import com.azure.ai.openai.models.ChatRequestUserMessage;
import com.azure.ai.openai.models.ChatResponseMessage;
import com.azure.ai.openai.models.CompletionsUsage;
import com.azure.ai.openai.models.FunctionCall;
import com.azure.core.util.BinaryData;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.microsoft.semantickernel.Kernel;
import com.microsoft.semantickernel.aiservices.openai.OpenAiService;
import com.microsoft.semantickernel.aiservices.openai.chatcompletion.OpenAIChatMessageContent;
import com.microsoft.semantickernel.aiservices.openai.chatcompletion.OpenAIFunction;
import com.microsoft.semantickernel.aiservices.openai.chatcompletion.OpenAIFunctionToolCall;
import com.microsoft.semantickernel.aiservices.openai.chatcompletion.ParsedPrompt;
import com.microsoft.semantickernel.aiservices.openai.chatcompletion.XMLPromptParser;
import com.microsoft.semantickernel.aiservices.openai.implementation.OpenAIRequestSettings;
import com.microsoft.semantickernel.contextvariables.ContextVariable;
import com.microsoft.semantickernel.contextvariables.ContextVariableTypes;
import com.microsoft.semantickernel.exceptions.AIException;
import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.hooks.KernelHookEvent;
import com.microsoft.semantickernel.hooks.KernelHooks;
import com.microsoft.semantickernel.hooks.PostChatCompletionEvent;
import com.microsoft.semantickernel.hooks.PreChatCompletionEvent;
import com.microsoft.semantickernel.hooks.PreToolCallEvent;
import com.microsoft.semantickernel.orchestration.FunctionResult;
import com.microsoft.semantickernel.orchestration.FunctionResultMetadata;
import com.microsoft.semantickernel.orchestration.InvocationContext;
import com.microsoft.semantickernel.orchestration.PromptExecutionSettings;
import com.microsoft.semantickernel.orchestration.ToolCallBehavior;
import com.microsoft.semantickernel.semanticfunctions.KernelFunction;
import com.microsoft.semantickernel.semanticfunctions.KernelFunctionArguments;
import com.microsoft.semantickernel.services.chatcompletion.AuthorRole;
import com.microsoft.semantickernel.services.chatcompletion.ChatCompletionService;
import com.microsoft.semantickernel.services.chatcompletion.ChatHistory;
import com.microsoft.semantickernel.services.chatcompletion.ChatMessageContent;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class OpenAIChatCompletion
extends OpenAiService
implements ChatCompletionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAIChatCompletion.class);

    protected OpenAIChatCompletion(OpenAIAsyncClient client, String modelId, @Nullable String serviceId) {
        super(client, serviceId, modelId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Mono<List<ChatMessageContent<?>>> getChatMessageContentsAsync(ChatHistory chatHistory, @Nullable Kernel kernel, @Nullable InvocationContext invocationContext) {
        List<ChatRequestMessage> chatRequestMessages = OpenAIChatCompletion.getChatRequestMessages(chatHistory);
        return this.internalChatMessageContentsAsync(chatRequestMessages, kernel, invocationContext);
    }

    public Mono<List<ChatMessageContent<?>>> getChatMessageContentsAsync(String prompt, @Nullable Kernel kernel, @Nullable InvocationContext invocationContext) {
        ParsedPrompt parsedPrompt = XMLPromptParser.parse(prompt);
        return this.internalChatMessageContentsAsync(parsedPrompt.getChatRequestMessages(), kernel, invocationContext);
    }

    private Mono<List<ChatMessageContent<?>>> internalChatMessageContentsAsync(List<ChatRequestMessage> messages, @Nullable Kernel kernel, @Nullable InvocationContext invocationContext) {
        ArrayList<OpenAIFunction> functions = new ArrayList<OpenAIFunction>();
        if (kernel != null) {
            kernel.getPlugins().forEach(plugin -> plugin.getFunctions().forEach((name, function) -> functions.add(OpenAIFunction.build(function.getMetadata(), plugin.getName()))));
        }
        return this.internalChatMessageContentsAsync(new ArrayList<ChatRequestMessage>(messages), kernel, functions, invocationContext, Math.min(5, invocationContext != null && invocationContext.getToolCallBehavior() != null ? invocationContext.getToolCallBehavior().getMaximumAutoInvokeAttempts() : 0));
    }

    private Mono<List<ChatMessageContent<?>>> internalChatMessageContentsAsync(List<ChatRequestMessage> messages, @Nullable Kernel kernel, List<OpenAIFunction> functions, @Nullable InvocationContext invocationContext, int autoInvokeAttempts) {
        ChatCompletionsOptions options = OpenAIChatCompletion.executeHook(invocationContext, new PreChatCompletionEvent(OpenAIChatCompletion.getCompletionsOptions(this, messages, functions, invocationContext))).getOptions();
        Mono result = this.getClient().getChatCompletionsWithResponse(this.getModelId(), options, OpenAIRequestSettings.getRequestOptions()).flatMap(completionsResult -> {
            if (completionsResult.getStatusCode() >= 400) {
                return Mono.error((Throwable)new AIException(AIException.ErrorCodes.SERVICE_ERROR, "Request failed: " + completionsResult.getStatusCode()));
            }
            return Mono.just((Object)((ChatCompletions)completionsResult.getValue()));
        }).flatMap(completions -> {
            List responseMessages = completions.getChoices().stream().map(ChatChoice::getMessage).filter(Objects::nonNull).collect(Collectors.toList());
            OpenAIChatCompletion.executeHook(invocationContext, new PostChatCompletionEvent(completions));
            if (autoInvokeAttempts == 0 || responseMessages.size() != 1) {
                return this.getChatMessageContentsAsync((ChatCompletions)completions);
            }
            ChatResponseMessage response = (ChatResponseMessage)responseMessages.get(0);
            List toolCalls = response.getToolCalls();
            if (toolCalls == null || toolCalls.isEmpty()) {
                return this.getChatMessageContentsAsync((ChatCompletions)completions);
            }
            ChatRequestAssistantMessage requestMessage = new ChatRequestAssistantMessage(response.getContent());
            requestMessage.setToolCalls(toolCalls);
            messages.add((ChatRequestMessage)requestMessage);
            return Flux.fromIterable((Iterable)toolCalls).reduce((Object)Mono.just((Object)messages), (requestMessages, toolCall) -> {
                if (toolCall instanceof ChatCompletionsFunctionToolCall) {
                    return this.performToolCall(kernel, invocationContext, (Mono<List<ChatRequestMessage>>)requestMessages, (ChatCompletionsToolCall)toolCall);
                }
                return requestMessages;
            }).flatMap(it -> it).flatMap(msgs -> this.internalChatMessageContentsAsync((List<ChatRequestMessage>)msgs, kernel, functions, invocationContext, autoInvokeAttempts - 1)).onErrorResume(e -> {
                LOGGER.warn("Tool invocation attempt failed: ", e);
                if (autoInvokeAttempts > 0) {
                    List<ChatRequestMessage> currentMessages = messages;
                    if (e instanceof FunctionInvocationError) {
                        currentMessages = ((FunctionInvocationError)((Object)((Object)((Object)e)))).getMessages();
                    }
                    return this.internalChatMessageContentsAsync(currentMessages, kernel, functions, invocationContext, autoInvokeAttempts - 1);
                }
                return Mono.error((Throwable)e);
            });
        });
        return result.map(op -> op);
    }

    private Mono<List<ChatRequestMessage>> performToolCall(@Nullable Kernel kernel, @Nullable InvocationContext invocationContext, Mono<List<ChatRequestMessage>> requestMessages, ChatCompletionsToolCall toolCall) {
        return requestMessages.flatMap(msgs -> {
            try {
                ChatCompletionsFunctionToolCall functionToolCall = (ChatCompletionsFunctionToolCall)toolCall;
                if (kernel == null) {
                    return Mono.error((Throwable)new SKException("A tool call was requested, but no kernel was provided to the invocation, this is a unsupported configuration"));
                }
                ContextVariableTypes contextVariableTypes = invocationContext == null ? new ContextVariableTypes() : invocationContext.getContextVariableTypes();
                return this.invokeFunctionTool(kernel, invocationContext, functionToolCall, contextVariableTypes).map(functionResult -> {
                    ChatRequestToolMessage requestToolMessage = new ChatRequestToolMessage((String)functionResult.getResult(), functionToolCall.getId());
                    ArrayList<ChatRequestToolMessage> res = new ArrayList<ChatRequestToolMessage>((Collection<ChatRequestToolMessage>)msgs);
                    res.add(requestToolMessage);
                    return res;
                }).switchIfEmpty(Mono.fromSupplier(() -> {
                    ChatRequestToolMessage requestToolMessage = new ChatRequestToolMessage("Completed successfully with no return value", functionToolCall.getId());
                    ArrayList<ChatRequestToolMessage> res = new ArrayList<ChatRequestToolMessage>((Collection<ChatRequestToolMessage>)msgs);
                    res.add(requestToolMessage);
                    return res;
                })).onErrorResume(e -> this.emitError(toolCall, (List<ChatRequestMessage>)msgs, (Throwable)e));
            }
            catch (Exception e2) {
                return this.emitError(toolCall, (List<ChatRequestMessage>)msgs, e2);
            }
        });
    }

    private Mono<ArrayList<ChatRequestMessage>> emitError(ChatCompletionsToolCall toolCall, List<ChatRequestMessage> msgs, Throwable e) {
        msgs.add((ChatRequestMessage)new ChatRequestToolMessage("Call failed: " + e.getMessage(), toolCall.getId()));
        return Mono.error((Throwable)((Object)new FunctionInvocationError(e, msgs)));
    }

    private Mono<FunctionResult<String>> invokeFunctionTool(Kernel kernel, @Nullable InvocationContext invocationContext, ChatCompletionsFunctionToolCall toolCall, ContextVariableTypes contextVariableTypes) {
        try {
            OpenAIFunctionToolCall openAIFunctionToolCall = this.extractOpenAIFunctionToolCall(toolCall);
            String pluginName = openAIFunctionToolCall.getPluginName();
            if (pluginName == null || pluginName.isEmpty()) {
                return Mono.error((Throwable)new SKException("Plugin name is required for function tool call"));
            }
            KernelFunction function = kernel.getFunction(pluginName, openAIFunctionToolCall.getFunctionName());
            PreToolCallEvent hookResult = OpenAIChatCompletion.executeHook(invocationContext, new PreToolCallEvent(openAIFunctionToolCall.getFunctionName(), openAIFunctionToolCall.getArguments(), function, contextVariableTypes));
            function = hookResult.getFunction();
            KernelFunctionArguments arguments = hookResult.getArguments();
            return function.invokeAsync(kernel).withArguments(arguments).withResultType(contextVariableTypes.getVariableTypeForClass(String.class));
        }
        catch (JsonProcessingException e) {
            return Mono.error((Throwable)new SKException("Failed to parse tool arguments"));
        }
    }

    private static <T extends KernelHookEvent> T executeHook(@Nullable InvocationContext invocationContext, T event) {
        KernelHooks kernelHooks = invocationContext != null && invocationContext.getKernelHooks() != null ? invocationContext.getKernelHooks() : new KernelHooks();
        return (T)kernelHooks.executeHooks(event);
    }

    private OpenAIFunctionToolCall extractOpenAIFunctionToolCall(ChatCompletionsFunctionToolCall toolCall) throws JsonProcessingException {
        String name = toolCall.getFunction().getName();
        String[] parts = name.split(OpenAIFunction.getNameSeparator());
        String pluginName = parts.length > 1 ? parts[0] : "";
        String fnName = parts.length > 1 ? parts[1] : parts[0];
        KernelFunctionArguments arguments = KernelFunctionArguments.builder().build();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonToolCallArguments = mapper.readTree(toolCall.getFunction().getArguments());
        jsonToolCallArguments.fields().forEachRemaining(entry -> {
            if (entry.getValue() instanceof ContainerNode) {
                arguments.put((String)entry.getKey(), ContextVariable.of((String)((JsonNode)entry.getValue()).toPrettyString()));
            } else {
                arguments.put((String)entry.getKey(), ContextVariable.of((String)((JsonNode)entry.getValue()).asText()));
            }
        });
        return new OpenAIFunctionToolCall(toolCall.getId(), pluginName, fnName, arguments);
    }

    private Mono<List<OpenAIChatMessageContent>> getChatMessageContentsAsync(ChatCompletions completions) {
        FunctionResultMetadata completionMetadata = FunctionResultMetadata.build((String)completions.getId(), (CompletionsUsage)completions.getUsage(), (OffsetDateTime)completions.getCreatedAt());
        List responseMessages = completions.getChoices().stream().map(ChatChoice::getMessage).filter(Objects::nonNull).collect(Collectors.toList());
        return Flux.fromIterable(responseMessages).map(response -> new OpenAIChatMessageContent<Object>(AuthorRole.ASSISTANT, response.getContent(), this.getModelId(), null, null, completionMetadata, this.formOpenAiToolCalls((ChatResponseMessage)response))).collectList();
    }

    private List<OpenAIFunctionToolCall> formOpenAiToolCalls(ChatResponseMessage response) {
        if (response.getToolCalls() == null || response.getToolCalls().isEmpty()) {
            return new ArrayList<OpenAIFunctionToolCall>();
        }
        return response.getToolCalls().stream().map(call -> {
            if (call instanceof ChatCompletionsFunctionToolCall) {
                try {
                    return this.extractOpenAIFunctionToolCall((ChatCompletionsFunctionToolCall)call);
                }
                catch (JsonProcessingException e) {
                    throw new SKException("Failed to parse tool arguments", (Throwable)e);
                }
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static ChatCompletionsOptions getCompletionsOptions(ChatCompletionService chatCompletionService, List<ChatRequestMessage> chatRequestMessages, @Nullable List<OpenAIFunction> functions, @Nullable InvocationContext invocationContext) {
        PromptExecutionSettings promptExecutionSettings;
        chatRequestMessages = chatRequestMessages.stream().map(XMLPromptParser::unescapeRequest).collect(Collectors.toList());
        ChatCompletionsOptions options = new ChatCompletionsOptions(chatRequestMessages).setModel(chatCompletionService.getModelId());
        if (invocationContext != null && invocationContext.getToolCallBehavior() != null) {
            OpenAIChatCompletion.configureToolCallBehaviorOptions(options, invocationContext.getToolCallBehavior(), functions, chatRequestMessages);
        }
        PromptExecutionSettings promptExecutionSettings2 = promptExecutionSettings = invocationContext != null ? invocationContext.getPromptExecutionSettings() : null;
        if (promptExecutionSettings == null) {
            return options;
        }
        if (promptExecutionSettings.getResultsPerPrompt() < 1 || promptExecutionSettings.getResultsPerPrompt() > 128) {
            throw new AIException(AIException.ErrorCodes.INVALID_REQUEST, String.format("Results per prompt must be in range between 1 and %d, inclusive.", 128));
        }
        Map<String, Integer> logit = null;
        if (promptExecutionSettings.getTokenSelectionBiases() != null) {
            logit = promptExecutionSettings.getTokenSelectionBiases().entrySet().stream().collect(Collectors.toMap(entry -> ((Integer)entry.getKey()).toString(), Map.Entry::getValue));
        }
        options.setTemperature(Double.valueOf(promptExecutionSettings.getTemperature())).setTopP(Double.valueOf(promptExecutionSettings.getTopP())).setPresencePenalty(Double.valueOf(promptExecutionSettings.getPresencePenalty())).setFrequencyPenalty(Double.valueOf(promptExecutionSettings.getFrequencyPenalty())).setPresencePenalty(Double.valueOf(promptExecutionSettings.getPresencePenalty())).setMaxTokens(Integer.valueOf(promptExecutionSettings.getMaxTokens())).setN(Integer.valueOf(promptExecutionSettings.getResultsPerPrompt())).setStop(promptExecutionSettings.getStopSequences() == null || promptExecutionSettings.getStopSequences().isEmpty() ? null : promptExecutionSettings.getStopSequences()).setUser(promptExecutionSettings.getUser()).setLogitBias(logit);
        if (promptExecutionSettings.getResponseFormat() != null) {
            switch (promptExecutionSettings.getResponseFormat()) {
                case JSON_OBJECT: {
                    options.setResponseFormat((ChatCompletionsResponseFormat)new ChatCompletionsJsonResponseFormat());
                    break;
                }
                case TEXT: {
                    options.setResponseFormat((ChatCompletionsResponseFormat)new ChatCompletionsTextResponseFormat());
                    break;
                }
                default: {
                    throw new SKException("Unknown response format: " + promptExecutionSettings.getResponseFormat());
                }
            }
        }
        return options;
    }

    private static void configureToolCallBehaviorOptions(ChatCompletionsOptions options, @Nullable ToolCallBehavior toolCallBehavior, @Nullable List<OpenAIFunction> functions, List<ChatRequestMessage> chatRequestMessages) {
        if (toolCallBehavior == null) {
            return;
        }
        if (functions == null || functions.isEmpty()) {
            return;
        }
        if (toolCallBehavior instanceof ToolCallBehavior.RequiredKernelFunction) {
            KernelFunction toolChoice = ((ToolCallBehavior.RequiredKernelFunction)toolCallBehavior).getRequiredFunction();
            String toolChoiceName = String.format("%s%s%s", toolChoice.getPluginName(), OpenAIFunction.getNameSeparator(), toolChoice.getName());
            boolean hasBeenExecuted = OpenAIChatCompletion.hasToolCallBeenExecuted(chatRequestMessages, toolChoiceName);
            if (hasBeenExecuted) {
                return;
            }
            ArrayList<ChatCompletionsFunctionToolDefinition> toolDefinitions = new ArrayList<ChatCompletionsFunctionToolDefinition>();
            toolDefinitions.add(new ChatCompletionsFunctionToolDefinition(OpenAIFunction.toFunctionDefinition(toolChoice.getMetadata(), toolChoice.getPluginName())));
            options.setTools(toolDefinitions);
            try {
                String json = String.format("{\"type\":\"function\",\"function\":{\"name\":\"%s\"}}", toolChoiceName);
                options.setToolChoice(BinaryData.fromObject((Object)new ObjectMapper().readTree(json)));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        ToolCallBehavior.AllowedKernelFunctions enabledKernelFunctions = (ToolCallBehavior.AllowedKernelFunctions)toolCallBehavior;
        List toolDefinitions = functions.stream().filter(function -> {
            if (enabledKernelFunctions.isAllKernelFunctionsAllowed()) {
                return true;
            }
            return enabledKernelFunctions.isFunctionAllowed(function.getPluginName(), function.getName());
        }).map(OpenAIFunction::getFunctionDefinition).map(ChatCompletionsFunctionToolDefinition::new).collect(Collectors.toList());
        if (toolDefinitions.isEmpty()) {
            return;
        }
        options.setTools(toolDefinitions);
        options.setToolChoice(BinaryData.fromString((String)"auto"));
    }

    private static boolean hasToolCallBeenExecuted(List<ChatRequestMessage> chatRequestMessages, String toolChoiceName) {
        return chatRequestMessages.stream().flatMap(message -> {
            if (message instanceof ChatRequestAssistantMessage) {
                return ((ChatRequestAssistantMessage)message).getToolCalls().stream();
            }
            return Stream.empty();
        }).filter(toolCall -> {
            if (toolCall instanceof ChatCompletionsFunctionToolCall) {
                return ((ChatCompletionsFunctionToolCall)toolCall).getFunction().getName().equals(toolChoiceName);
            }
            return false;
        }).allMatch(toolcall -> {
            String id = toolcall.getId();
            return chatRequestMessages.stream().filter(chatRequestMessage -> chatRequestMessage instanceof ChatRequestToolMessage).anyMatch(chatRequestMessage -> ((ChatRequestToolMessage)chatRequestMessage).getToolCallId().equals(id));
        });
    }

    private static List<ChatRequestMessage> getChatRequestMessages(ChatHistory chatHistory) {
        List messages = chatHistory.getMessages();
        if (messages == null || messages.isEmpty()) {
            return new ArrayList<ChatRequestMessage>();
        }
        return messages.stream().map(OpenAIChatCompletion::getChatRequestMessage).collect(Collectors.toList());
    }

    private static ChatRequestMessage getChatRequestMessage(ChatMessageContent<?> message) {
        AuthorRole authorRole = message.getAuthorRole();
        String content = message.getContent();
        switch (authorRole) {
            case ASSISTANT: {
                return OpenAIChatCompletion.formAssistantMessage(message, content);
            }
            case SYSTEM: {
                return new ChatRequestSystemMessage(content);
            }
            case USER: {
                return new ChatRequestUserMessage(content);
            }
            case TOOL: {
                String id = null;
                if (message.getMetadata() != null) {
                    id = message.getMetadata().getId();
                }
                if (id == null) {
                    throw new SKException("Require to create a tool call message, but not tool call id is available");
                }
                return new ChatRequestToolMessage(content, id);
            }
        }
        LOGGER.debug("Unexpected author role: {}", (Object)authorRole);
        throw new SKException("Unexpected author role: " + authorRole);
    }

    private static ChatRequestAssistantMessage formAssistantMessage(ChatMessageContent<?> message, @Nullable String content) {
        ChatRequestAssistantMessage asstMessage = new ChatRequestAssistantMessage(content);
        List<OpenAIFunctionToolCall> toolCalls = null;
        if (message instanceof OpenAIChatMessageContent) {
            toolCalls = ((OpenAIChatMessageContent)message).getToolCall();
        }
        if (toolCalls != null) {
            asstMessage.setToolCalls(toolCalls.stream().map(toolCall -> {
                KernelFunctionArguments arguments = toolCall.getArguments();
                String args = arguments != null && !arguments.isEmpty() ? arguments.entrySet().stream().map(entry -> String.format("\"%s\": \"%s\"", StringEscapeUtils.escapeJson((String)((String)entry.getKey())), StringEscapeUtils.escapeJson((String)((ContextVariable)entry.getValue()).toPromptString()))).collect(Collectors.joining("{", "}", ",")) : "{}";
                FunctionCall fnCall = new FunctionCall(toolCall.getFunctionName(), args);
                return new ChatCompletionsFunctionToolCall(toolCall.getId(), fnCall);
            }).collect(Collectors.toList()));
        }
        return asstMessage;
    }

    static ChatRequestMessage getChatRequestMessage(AuthorRole authorRole, String content) {
        switch (authorRole) {
            case ASSISTANT: {
                return new ChatRequestAssistantMessage(content);
            }
            case SYSTEM: {
                return new ChatRequestSystemMessage(content);
            }
            case USER: {
                return new ChatRequestUserMessage(content);
            }
            case TOOL: {
                return new ChatRequestToolMessage(content, null);
            }
        }
        LOGGER.debug("Unexpected author role: " + authorRole);
        throw new SKException("Unexpected author role: " + authorRole);
    }

    public static class Builder
    extends ChatCompletionService.Builder {
        public OpenAIChatCompletion build() {
            if (this.client == null) {
                throw new AIException(AIException.ErrorCodes.INVALID_REQUEST, "OpenAI client must be provided");
            }
            if (this.modelId == null || this.modelId.isEmpty()) {
                throw new AIException(AIException.ErrorCodes.INVALID_REQUEST, "OpenAI model id must be provided");
            }
            return new OpenAIChatCompletion(this.client, this.modelId, this.serviceId);
        }
    }

    private static class FunctionInvocationError
    extends SKException {
        private final List<ChatRequestMessage> messages;

        public FunctionInvocationError(Throwable e, List<ChatRequestMessage> msgs) {
            super(e.getMessage(), e);
            this.messages = msgs;
        }

        public List<ChatRequestMessage> getMessages() {
            return this.messages;
        }
    }
}

