/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.aiservices.openai.audio;

import com.azure.ai.openai.OpenAIAsyncClient;
import com.azure.ai.openai.models.SpeechGenerationOptions;
import com.azure.ai.openai.models.SpeechGenerationResponseFormat;
import com.azure.ai.openai.models.SpeechVoice;
import com.microsoft.semantickernel.aiservices.openai.OpenAiService;
import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.services.audio.AudioContent;
import com.microsoft.semantickernel.services.audio.TextToAudioExecutionSettings;
import com.microsoft.semantickernel.services.audio.TextToAudioService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class OpenAiTextToAudioService
extends OpenAiService
implements TextToAudioService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAiTextToAudioService.class);

    public OpenAiTextToAudioService(OpenAIAsyncClient client, String modelId, String deploymentName) {
        super(client, null, modelId, deploymentName);
    }

    public Mono<AudioContent> getAudioContentAsync(String text, TextToAudioExecutionSettings executionSettings) {
        SpeechGenerationOptions options = this.convertOptions(text, executionSettings);
        return this.getClient().generateSpeechFromText(this.getDeploymentName(), options).map(response -> new AudioContent(response.toBytes(), this.getModelId()));
    }

    private SpeechGenerationOptions convertOptions(String text, TextToAudioExecutionSettings executionSettings) {
        SpeechGenerationOptions options = new SpeechGenerationOptions(text, SpeechVoice.fromString((String)executionSettings.getVoice()));
        options.setModel(this.getModelId());
        if (executionSettings.getResponseFormat() != null) {
            options.setResponseFormat(SpeechGenerationResponseFormat.fromString((String)executionSettings.getResponseFormat()));
        }
        if (executionSettings.getSpeed() != null) {
            options.setSpeed(executionSettings.getSpeed());
        }
        return options;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends TextToAudioService.Builder {
        public TextToAudioService build() {
            if (this.client == null) {
                throw new SKException("OpenAI client is required");
            }
            if (this.modelId == null) {
                throw new SKException("Model id is required");
            }
            if (this.deploymentName == null) {
                LOGGER.debug("Deployment name is not provided, using model id as deployment name");
                this.deploymentName = this.modelId;
            }
            return new OpenAiTextToAudioService(this.client, this.modelId, this.deploymentName);
        }
    }
}

