/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.aiservices.openai.implementation;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.util.Context;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenAIRequestSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAIRequestSettings.class);
    private static final String SEMANTIC_KERNEL_VERSION_PROPERTY_NAME = "semantic-kernel.version";
    private static final String SEMANTIC_KERNEL_VERSION_PROPERTIES_FILE = "semantic-kernel-version.properties";
    private static final String useragent;
    private static final String header;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadVersion() {
        String version = "unknown";
        try (InputStream settingsFile = OpenAIRequestSettings.class.getResourceAsStream(SEMANTIC_KERNEL_VERSION_PROPERTIES_FILE);){
            Properties props = new Properties();
            props.load(settingsFile);
            if (!props.containsKey(SEMANTIC_KERNEL_VERSION_PROPERTY_NAME)) return version;
            String skVersion = props.getProperty(SEMANTIC_KERNEL_VERSION_PROPERTY_NAME);
            if (skVersion == null) return version;
            if (skVersion.isEmpty()) return version;
            String string = skVersion;
            return string;
        }
        catch (IOException e) {
            LOGGER.trace("Failed to load Semantic Kernel version from properties file", (Throwable)e);
        }
        return version;
    }

    public static RequestOptions getRequestOptions() {
        return new RequestOptions().setHeader(HttpHeaderName.fromString((String)"Semantic-Kernel-Version"), header).setContext(new Context((Object)"Append-User-Agent", (Object)useragent));
    }

    static {
        String version = OpenAIRequestSettings.loadVersion();
        useragent = "semantic-kernel-java/" + version;
        header = "java/" + version;
    }
}

