/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.aiservices.openai.audio;

import com.azure.ai.openai.OpenAIAsyncClient;
import com.azure.ai.openai.models.AudioTranscription;
import com.azure.ai.openai.models.AudioTranscriptionFormat;
import com.azure.ai.openai.models.AudioTranscriptionOptions;
import com.microsoft.semantickernel.aiservices.openai.OpenAiService;
import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.services.audio.AudioContent;
import com.microsoft.semantickernel.services.audio.AudioToTextExecutionSettings;
import com.microsoft.semantickernel.services.audio.AudioToTextService;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class OpenAiAudioToTextService
extends OpenAiService<OpenAIAsyncClient>
implements AudioToTextService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAiAudioToTextService.class);

    public OpenAiAudioToTextService(OpenAIAsyncClient client, String modelId, String deploymentName) {
        super(client, null, modelId, deploymentName);
    }

    public Mono<String> getTextContentsAsync(AudioContent content, @Nullable AudioToTextExecutionSettings executionSettings) {
        AudioTranscriptionOptions options = this.convertOptions(content, executionSettings);
        return ((OpenAIAsyncClient)this.getClient()).getAudioTranscription(this.getDeploymentName(), options.getFilename(), options).map(AudioTranscription::getText);
    }

    private AudioTranscriptionOptions convertOptions(AudioContent content, @Nullable AudioToTextExecutionSettings executionSettings) {
        AudioTranscriptionOptions options = new AudioTranscriptionOptions(content.getData());
        options.setModel(this.getModelId());
        if (executionSettings == null) {
            return options;
        }
        if (executionSettings.getResponseFormat() != null) {
            options.setResponseFormat(AudioTranscriptionFormat.fromString((String)executionSettings.getResponseFormat()));
        }
        if (executionSettings.getFilename() != null) {
            options.setFilename(executionSettings.getFilename());
        }
        if (executionSettings.getLanguage() != null) {
            options.setLanguage(executionSettings.getLanguage());
        }
        if (executionSettings.getPrompt() != null) {
            options.setPrompt(executionSettings.getPrompt());
        }
        if (executionSettings.getTemperature() != null) {
            options.setTemperature(executionSettings.getTemperature());
        }
        return options;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AudioToTextService.Builder {
        public AudioToTextService build() {
            if (this.client == null) {
                throw new SKException("OpenAI client is required");
            }
            if (this.modelId == null) {
                throw new SKException("Model id is required");
            }
            if (this.deploymentName == null) {
                LOGGER.debug("Deployment name is not provided, using model id as deployment name");
                this.deploymentName = this.modelId;
            }
            return new OpenAiAudioToTextService((OpenAIAsyncClient)this.client, this.modelId, this.deploymentName);
        }
    }
}

