/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.aiservices.openai.textembedding;

import com.azure.ai.openai.OpenAIAsyncClient;
import com.azure.ai.openai.models.EmbeddingItem;
import com.azure.ai.openai.models.Embeddings;
import com.azure.ai.openai.models.EmbeddingsOptions;
import com.microsoft.semantickernel.aiservices.openai.OpenAiService;
import com.microsoft.semantickernel.exceptions.AIException;
import com.microsoft.semantickernel.services.openai.OpenAiServiceBuilder;
import com.microsoft.semantickernel.services.textembedding.Embedding;
import com.microsoft.semantickernel.services.textembedding.TextEmbeddingGenerationService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class OpenAITextEmbeddingGenerationService
extends OpenAiService<OpenAIAsyncClient>
implements TextEmbeddingGenerationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAITextEmbeddingGenerationService.class);
    private static final int DEFAULT_DIMENSIONS = 1536;
    private final int dimensions;

    public OpenAITextEmbeddingGenerationService(OpenAIAsyncClient client, String deploymentName, String modelId, @Nullable String serviceId, int dimensions) {
        super(client, serviceId, modelId, deploymentName);
        this.dimensions = dimensions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Mono<List<Embedding>> generateEmbeddingsAsync(List<String> data) {
        return this.internalGenerateTextEmbeddingsAsync(data);
    }

    protected Mono<List<Embedding>> internalGenerateTextEmbeddingsAsync(List<String> data) {
        EmbeddingsOptions options = new EmbeddingsOptions(data).setModel(this.getModelId()).setDimensions(Integer.valueOf(this.dimensions)).setInputType("string");
        return ((OpenAIAsyncClient)this.getClient()).getEmbeddings(this.getModelId(), options).flatMapIterable(Embeddings::getData).mapNotNull(EmbeddingItem::getEmbedding).map(ArrayList::new).mapNotNull(Embedding::new).collectList();
    }

    public static class Builder
    extends OpenAiServiceBuilder<OpenAIAsyncClient, OpenAITextEmbeddingGenerationService, Builder> {
        private int dimensions = 1536;

        public Builder withDimensions(int dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public OpenAITextEmbeddingGenerationService build() {
            if (this.client == null) {
                throw new AIException(AIException.ErrorCodes.INVALID_REQUEST, "OpenAI client must be provided");
            }
            if (this.modelId == null || this.modelId.isEmpty()) {
                throw new AIException(AIException.ErrorCodes.INVALID_REQUEST, "OpenAI model id must be provided");
            }
            if (this.deploymentName == null) {
                LOGGER.debug("Deployment name is not provided, using model id as deployment name");
                this.deploymentName = this.modelId;
            }
            return new OpenAITextEmbeddingGenerationService((OpenAIAsyncClient)this.client, this.deploymentName, this.modelId, this.serviceId, this.dimensions);
        }
    }
}

