/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.aiservices.openai.chatcompletion;

import com.azure.ai.openai.OpenAIAsyncClient;
import com.azure.ai.openai.models.ChatChoice;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsFunctionToolCall;
import com.azure.ai.openai.models.ChatCompletionsFunctionToolDefinition;
import com.azure.ai.openai.models.ChatCompletionsFunctionToolDefinitionFunction;
import com.azure.ai.openai.models.ChatCompletionsJsonResponseFormat;
import com.azure.ai.openai.models.ChatCompletionsNamedToolSelection;
import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.ChatCompletionsResponseFormat;
import com.azure.ai.openai.models.ChatCompletionsTextResponseFormat;
import com.azure.ai.openai.models.ChatCompletionsToolCall;
import com.azure.ai.openai.models.ChatCompletionsToolSelection;
import com.azure.ai.openai.models.ChatCompletionsToolSelectionPreset;
import com.azure.ai.openai.models.ChatMessageImageContentItem;
import com.azure.ai.openai.models.ChatMessageImageDetailLevel;
import com.azure.ai.openai.models.ChatMessageImageUrl;
import com.azure.ai.openai.models.ChatRequestAssistantMessage;
import com.azure.ai.openai.models.ChatRequestFunctionMessage;
import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.ChatRequestSystemMessage;
import com.azure.ai.openai.models.ChatRequestToolMessage;
import com.azure.ai.openai.models.ChatRequestUserMessage;
import com.azure.ai.openai.models.ChatResponseMessage;
import com.azure.ai.openai.models.CompletionsUsage;
import com.azure.ai.openai.models.FunctionCall;
import com.azure.ai.openai.models.FunctionDefinition;
import com.azure.json.JsonOptions;
import com.azure.json.JsonReader;
import com.azure.json.implementation.DefaultJsonReader;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.microsoft.semantickernel.Kernel;
import com.microsoft.semantickernel.aiservices.openai.OpenAiService;
import com.microsoft.semantickernel.aiservices.openai.chatcompletion.BinaryDataUtils;
import com.microsoft.semantickernel.aiservices.openai.chatcompletion.OpenAIChatMessageContent;
import com.microsoft.semantickernel.aiservices.openai.chatcompletion.OpenAIFunction;
import com.microsoft.semantickernel.aiservices.openai.chatcompletion.OpenAIFunctionToolCall;
import com.microsoft.semantickernel.aiservices.openai.chatcompletion.OpenAIStreamingChatMessageContent;
import com.microsoft.semantickernel.aiservices.openai.chatcompletion.OpenAiXMLPromptParser;
import com.microsoft.semantickernel.aiservices.openai.chatcompletion.ParsedPrompt;
import com.microsoft.semantickernel.aiservices.openai.chatcompletion.responseformat.ChatCompletionsJsonSchemaResponseFormat;
import com.microsoft.semantickernel.aiservices.openai.implementation.OpenAIRequestSettings;
import com.microsoft.semantickernel.contextvariables.ContextVariable;
import com.microsoft.semantickernel.contextvariables.ContextVariableTypes;
import com.microsoft.semantickernel.exceptions.AIException;
import com.microsoft.semantickernel.exceptions.SKCheckedException;
import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.hooks.KernelHookEvent;
import com.microsoft.semantickernel.hooks.KernelHooks;
import com.microsoft.semantickernel.hooks.PostChatCompletionEvent;
import com.microsoft.semantickernel.hooks.PreChatCompletionEvent;
import com.microsoft.semantickernel.hooks.PreToolCallEvent;
import com.microsoft.semantickernel.implementation.CollectionUtil;
import com.microsoft.semantickernel.implementation.telemetry.SemanticKernelTelemetry;
import com.microsoft.semantickernel.orchestration.FunctionResult;
import com.microsoft.semantickernel.orchestration.FunctionResultMetadata;
import com.microsoft.semantickernel.orchestration.InvocationContext;
import com.microsoft.semantickernel.orchestration.InvocationReturnMode;
import com.microsoft.semantickernel.orchestration.PromptExecutionSettings;
import com.microsoft.semantickernel.orchestration.ToolCallBehavior;
import com.microsoft.semantickernel.orchestration.responseformat.JsonResponseSchema;
import com.microsoft.semantickernel.orchestration.responseformat.JsonSchemaResponseFormat;
import com.microsoft.semantickernel.semanticfunctions.KernelFunction;
import com.microsoft.semantickernel.semanticfunctions.KernelFunctionArguments;
import com.microsoft.semantickernel.services.chatcompletion.AuthorRole;
import com.microsoft.semantickernel.services.chatcompletion.ChatCompletionService;
import com.microsoft.semantickernel.services.chatcompletion.ChatHistory;
import com.microsoft.semantickernel.services.chatcompletion.ChatMessageContent;
import com.microsoft.semantickernel.services.chatcompletion.StreamingChatContent;
import com.microsoft.semantickernel.services.chatcompletion.message.ChatMessageContentType;
import com.microsoft.semantickernel.services.chatcompletion.message.ChatMessageImageContent;
import com.microsoft.semantickernel.services.openai.OpenAiServiceBuilder;
import io.opentelemetry.api.trace.Span;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class OpenAIChatCompletion
extends OpenAiService<OpenAIAsyncClient>
implements ChatCompletionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAIChatCompletion.class);

    protected OpenAIChatCompletion(OpenAIAsyncClient client, String deploymentName, String modelId, @Nullable String serviceId) {
        super(client, serviceId, modelId, deploymentName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Mono<List<ChatMessageContent<?>>> getChatMessageContentsAsync(ChatHistory chatHistory, @Nullable Kernel kernel, @Nullable InvocationContext invocationContext) {
        List<ChatRequestMessage> chatRequestMessages = OpenAIChatCompletion.getChatRequestMessages(chatHistory);
        ChatMessages messages = new ChatMessages(chatRequestMessages);
        return this.internalChatMessageContentsAsync(messages, kernel, invocationContext).flatMap(history -> {
            try {
                ChatHistory chatHistoryResult = invocationContext != null && invocationContext.returnMode() == InvocationReturnMode.FULL_HISTORY ? new ChatHistory(chatHistory.getMessages()) : new ChatHistory();
                chatHistoryResult.addAll(new ChatHistory(this.toOpenAIChatMessageContent(((ChatMessages)history).newMessages)));
                chatHistoryResult.addAll(new ChatHistory(((ChatMessages)history).newChatMessageContent));
                if (invocationContext != null && invocationContext.returnMode() == InvocationReturnMode.LAST_MESSAGE_ONLY) {
                    chatHistoryResult = new ChatHistory(Collections.singletonList((ChatMessageContent)CollectionUtil.getLastOrNull((List)chatHistoryResult.getMessages())));
                }
                return Mono.just((Object)chatHistoryResult.getMessages());
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
        });
    }

    public Mono<List<ChatMessageContent<?>>> getChatMessageContentsAsync(String prompt, @Nullable Kernel kernel, @Nullable InvocationContext invocationContext) {
        ParsedPrompt parsedPrompt = OpenAiXMLPromptParser.parse(prompt);
        ChatMessages messages = new ChatMessages(parsedPrompt.getChatRequestMessages());
        return this.internalChatMessageContentsAsync(messages, kernel, invocationContext).flatMap(m -> {
            try {
                ChatHistory result = new ChatHistory(this.toOpenAIChatMessageContent(((ChatMessages)m).allMessages));
                result.addAll(new ChatHistory(((ChatMessages)m).newChatMessageContent));
                if (invocationContext != null && invocationContext.returnMode() == InvocationReturnMode.LAST_MESSAGE_ONLY) {
                    result = new ChatHistory(Collections.singletonList((ChatMessageContent)CollectionUtil.getLastOrNull((List)result.getMessages())));
                }
                return Mono.just((Object)result.getMessages());
            }
            catch (SKCheckedException e) {
                return Mono.error((Throwable)e);
            }
        });
    }

    public Flux<StreamingChatContent<?>> getStreamingChatMessageContentsAsync(ChatHistory chatHistory, @Nullable Kernel kernel, @Nullable InvocationContext invocationContext) {
        if (invocationContext != null && invocationContext.getToolCallBehavior().isAutoInvokeAllowed()) {
            throw new SKException("Auto invoke is not supported for streaming chat message contents");
        }
        if (invocationContext != null && invocationContext.returnMode() != InvocationReturnMode.NEW_MESSAGES_ONLY) {
            throw new SKException("Streaming chat message contents only supports NEW_MESSAGES_ONLY return mode");
        }
        List<ChatRequestMessage> chatRequestMessages = OpenAIChatCompletion.getChatRequestMessages(chatHistory);
        ChatMessages messages = new ChatMessages(chatRequestMessages);
        ArrayList<OpenAIFunction> functions = new ArrayList<OpenAIFunction>();
        if (kernel != null) {
            kernel.getPlugins().forEach(plugin -> plugin.getFunctions().forEach((name, function) -> functions.add(OpenAIFunction.build(function.getMetadata(), plugin.getName()))));
        }
        ChatCompletionsOptions options = OpenAIChatCompletion.executeHook(invocationContext, kernel, new PreChatCompletionEvent(OpenAIChatCompletion.getCompletionsOptions(this, messages.allMessages, functions, invocationContext))).getOptions();
        return ((OpenAIAsyncClient)this.getClient()).getChatCompletionsStreamWithResponse(this.getDeploymentName(), options, OpenAIRequestSettings.getRequestOptions()).flatMap(completionsResult -> {
            if (completionsResult.getStatusCode() >= 400) {
                return Mono.error((Throwable)new AIException(AIException.ErrorCodes.SERVICE_ERROR, "Request failed: " + completionsResult.getStatusCode()));
            }
            return Mono.just((Object)((ChatCompletions)completionsResult.getValue()));
        }).flatMap(completions -> Flux.fromIterable((Iterable)completions.getChoices()).map(message -> {
            AuthorRole role = message.getDelta().getRole() == null ? AuthorRole.ASSISTANT : AuthorRole.valueOf((String)message.getDelta().getRole().toString().toUpperCase(Locale.ROOT));
            return new OpenAIStreamingChatMessageContent<Object>(completions.getId(), role, message.getDelta().getContent(), this.getModelId(), null, null, null, Arrays.asList(new OpenAIFunctionToolCall[0]));
        }));
    }

    public Flux<StreamingChatContent<?>> getStreamingChatMessageContentsAsync(String prompt, @Nullable Kernel kernel, @Nullable InvocationContext invocationContext) {
        return this.getStreamingChatMessageContentsAsync(new ChatHistory().addUserMessage(prompt), kernel, invocationContext);
    }

    private Mono<ChatMessages> internalChatMessageContentsAsync(ChatMessages messages, @Nullable Kernel kernel, @Nullable InvocationContext invocationContext) {
        ArrayList<OpenAIFunction> functions = new ArrayList<OpenAIFunction>();
        if (kernel != null) {
            kernel.getPlugins().forEach(plugin -> plugin.getFunctions().forEach((name, function) -> functions.add(OpenAIFunction.build(function.getMetadata(), plugin.getName()))));
        }
        return this.internalChatMessageContentsAsync(messages, kernel, functions, invocationContext, Math.min(5, invocationContext != null && invocationContext.getToolCallBehavior() != null ? invocationContext.getToolCallBehavior().getMaximumAutoInvokeAttempts() : 0));
    }

    private Mono<ChatMessages> internalChatMessageContentsAsync(ChatMessages messages, @Nullable Kernel kernel, List<OpenAIFunction> functions, @Nullable InvocationContext invocationContext, int autoInvokeAttempts) {
        ChatCompletionsOptions options = OpenAIChatCompletion.executeHook(invocationContext, kernel, new PreChatCompletionEvent(OpenAIChatCompletion.getCompletionsOptions(this, messages.allMessages, functions, invocationContext))).getOptions();
        Span span = SemanticKernelTelemetry.startChatCompletionSpan((String)this.getModelId(), (String)"openai", (Integer)options.getMaxTokens(), (Double)options.getTemperature(), (Double)options.getTopP());
        return ((OpenAIAsyncClient)this.getClient()).getChatCompletionsWithResponse(this.getDeploymentName(), options, OpenAIRequestSettings.getRequestOptions()).flatMap(completionsResult -> {
            if (completionsResult.getStatusCode() >= 400) {
                SemanticKernelTelemetry.endSpanWithError((Span)span);
                return Mono.error((Throwable)new AIException(AIException.ErrorCodes.SERVICE_ERROR, "Request failed: " + completionsResult.getStatusCode()));
            }
            SemanticKernelTelemetry.endSpanWithUsage((Span)span, (CompletionsUsage)((ChatCompletions)completionsResult.getValue()).getUsage());
            return Mono.just((Object)((ChatCompletions)completionsResult.getValue()));
        }).flatMap(completions -> {
            List responseMessages = completions.getChoices().stream().map(ChatChoice::getMessage).filter(Objects::nonNull).collect(Collectors.toList());
            OpenAIChatCompletion.executeHook(invocationContext, kernel, new PostChatCompletionEvent(completions));
            if (autoInvokeAttempts == 0 || responseMessages.size() != 1) {
                List<OpenAIChatMessageContent<?>> chatMessageContents = this.getChatMessageContentsAsync((ChatCompletions)completions);
                return Mono.just((Object)messages.addChatMessage(chatMessageContents));
            }
            ChatResponseMessage response = (ChatResponseMessage)responseMessages.get(0);
            List toolCalls = response.getToolCalls();
            if (toolCalls == null || toolCalls.isEmpty()) {
                List<OpenAIChatMessageContent<?>> chatMessageContents = this.getChatMessageContentsAsync((ChatCompletions)completions);
                return Mono.just((Object)messages.addChatMessage(chatMessageContents));
            }
            ChatRequestAssistantMessage requestMessage = new ChatRequestAssistantMessage(response.getContent());
            requestMessage.setToolCalls(toolCalls);
            ChatMessages messagesWithToolCall = messages.add((ChatRequestMessage)requestMessage);
            return Flux.fromIterable((Iterable)toolCalls).reduce((Object)Mono.just((Object)messagesWithToolCall), (requestMessages, toolCall) -> {
                if (toolCall instanceof ChatCompletionsFunctionToolCall) {
                    return this.performToolCall(kernel, invocationContext, (Mono<ChatMessages>)requestMessages, (ChatCompletionsToolCall)toolCall);
                }
                return requestMessages;
            }).flatMap(it -> it).flatMap(msgs -> this.internalChatMessageContentsAsync((ChatMessages)msgs, kernel, functions, invocationContext, autoInvokeAttempts - 1)).onErrorResume(e -> {
                LOGGER.warn("Tool invocation attempt failed: ", e);
                if (autoInvokeAttempts > 0) {
                    ChatMessages currentMessages = messages;
                    if (e instanceof FunctionInvocationError) {
                        currentMessages.assertCommonHistory(((FunctionInvocationError)((Object)((Object)((Object)e)))).getMessages());
                        currentMessages = new ChatMessages(((FunctionInvocationError)((Object)((Object)((Object)e)))).getMessages());
                    }
                    return this.internalChatMessageContentsAsync(currentMessages, kernel, functions, invocationContext, autoInvokeAttempts - 1);
                }
                return Mono.error((Throwable)e);
            });
        });
    }

    private Mono<ChatMessages> performToolCall(@Nullable Kernel kernel, @Nullable InvocationContext invocationContext, Mono<ChatMessages> requestMessages, ChatCompletionsToolCall toolCall) {
        return requestMessages.flatMap(messages -> {
            try {
                ChatCompletionsFunctionToolCall functionToolCall = (ChatCompletionsFunctionToolCall)toolCall;
                if (kernel == null) {
                    return Mono.error((Throwable)new SKException("A tool call was requested, but no kernel was provided to the invocation, this is a unsupported configuration"));
                }
                ContextVariableTypes contextVariableTypes = invocationContext == null ? new ContextVariableTypes() : invocationContext.getContextVariableTypes();
                return this.invokeFunctionTool(kernel, invocationContext, functionToolCall, contextVariableTypes).map(functionResult -> {
                    ChatRequestToolMessage requestToolMessage = new ChatRequestToolMessage((String)functionResult.getResult(), functionToolCall.getId());
                    return messages.add((ChatRequestMessage)requestToolMessage);
                }).switchIfEmpty(Mono.fromSupplier(() -> {
                    ChatRequestToolMessage requestToolMessage = new ChatRequestToolMessage("Completed successfully with no return value", functionToolCall.getId());
                    return messages.add((ChatRequestMessage)requestToolMessage);
                })).onErrorResume(e -> this.emitError(toolCall, (ChatMessages)messages, (Throwable)e));
            }
            catch (Exception e2) {
                return this.emitError(toolCall, (ChatMessages)messages, e2);
            }
        });
    }

    private Mono<ChatMessages> emitError(ChatCompletionsToolCall toolCall, ChatMessages msgs, Throwable e) {
        msgs = msgs.add((ChatRequestMessage)new ChatRequestToolMessage("Call failed: " + e.getMessage(), toolCall.getId()));
        return Mono.error((Throwable)((Object)new FunctionInvocationError(e, msgs.allMessages)));
    }

    private Mono<FunctionResult<String>> invokeFunctionTool(Kernel kernel, @Nullable InvocationContext invocationContext, ChatCompletionsFunctionToolCall toolCall, ContextVariableTypes contextVariableTypes) {
        try {
            OpenAIFunctionToolCall openAIFunctionToolCall = this.extractOpenAIFunctionToolCall(toolCall);
            String pluginName = openAIFunctionToolCall.getPluginName();
            if (pluginName == null || pluginName.isEmpty()) {
                return Mono.error((Throwable)new SKException("Plugin name is required for function tool call"));
            }
            KernelFunction function = kernel.getFunction(pluginName, openAIFunctionToolCall.getFunctionName());
            PreToolCallEvent hookResult = OpenAIChatCompletion.executeHook(invocationContext, kernel, new PreToolCallEvent(openAIFunctionToolCall.getFunctionName(), openAIFunctionToolCall.getArguments(), function, contextVariableTypes));
            function = hookResult.getFunction();
            KernelFunctionArguments arguments = hookResult.getArguments();
            return function.invokeAsync(kernel).withArguments(arguments).withTypes(invocationContext.getContextVariableTypes()).withTypes(contextVariableTypes).withResultType(contextVariableTypes.getVariableTypeForClass(String.class));
        }
        catch (JsonProcessingException e) {
            return Mono.error((Throwable)new SKException("Failed to parse tool arguments", (Throwable)e));
        }
    }

    private static <T extends KernelHookEvent> T executeHook(@Nullable InvocationContext invocationContext, @Nullable Kernel kernel, T event) {
        KernelHooks.UnmodifiableKernelHooks kernelHooks = null;
        if (kernel == null) {
            if (invocationContext != null) {
                kernelHooks = invocationContext.getKernelHooks();
            }
        } else {
            kernelHooks = KernelHooks.merge((KernelHooks)kernel.getGlobalKernelHooks(), (KernelHooks)(invocationContext != null ? invocationContext.getKernelHooks() : null));
        }
        if (kernelHooks == null) {
            return event;
        }
        return (T)kernelHooks.executeHooks(event);
    }

    private OpenAIFunctionToolCall extractOpenAIFunctionToolCall(ChatCompletionsFunctionToolCall toolCall) throws JsonProcessingException {
        String name = toolCall.getFunction().getName();
        String[] parts = name.split(OpenAIFunction.getNameSeparator());
        String pluginName = parts.length > 1 ? parts[0] : "";
        String fnName = parts.length > 1 ? parts[1] : parts[0];
        KernelFunctionArguments arguments = KernelFunctionArguments.builder().build();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonToolCallArguments = mapper.readTree(toolCall.getFunction().getArguments());
        jsonToolCallArguments.fields().forEachRemaining(entry -> {
            if (entry.getValue() instanceof ContainerNode) {
                arguments.put((String)entry.getKey(), ContextVariable.of((String)((JsonNode)entry.getValue()).toPrettyString()));
            } else {
                arguments.put((String)entry.getKey(), ContextVariable.of((String)((JsonNode)entry.getValue()).asText()));
            }
        });
        return new OpenAIFunctionToolCall(toolCall.getId(), pluginName, fnName, arguments);
    }

    private List<OpenAIChatMessageContent<?>> getChatMessageContentsAsync(ChatCompletions completions) {
        FunctionResultMetadata completionMetadata = FunctionResultMetadata.build((String)completions.getId(), (Object)completions.getUsage(), (OffsetDateTime)completions.getCreatedAt());
        List responseMessages = completions.getChoices().stream().map(ChatChoice::getMessage).filter(Objects::nonNull).collect(Collectors.toList());
        List<OpenAIChatMessageContent<?>> chatMessageContent = responseMessages.stream().map(response -> {
            try {
                return new OpenAIChatMessageContent<Object>(AuthorRole.ASSISTANT, response.getContent(), this.getModelId(), null, null, completionMetadata, this.formOpenAiToolCalls((ChatResponseMessage)response));
            }
            catch (SKCheckedException e) {
                LOGGER.warn("Failed to form chat message content", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return chatMessageContent;
    }

    private List<ChatMessageContent<?>> toOpenAIChatMessageContent(List<ChatRequestMessage> requestMessages) throws SKCheckedException {
        try {
            return requestMessages.stream().map(message -> {
                if (message instanceof ChatRequestUserMessage) {
                    return new OpenAIChatMessageContent<Object>(AuthorRole.USER, BinaryDataUtils.toString(((ChatRequestUserMessage)message).getContent()), null, null, null, null, null);
                }
                if (message instanceof ChatRequestSystemMessage) {
                    return new OpenAIChatMessageContent<Object>(AuthorRole.SYSTEM, BinaryDataUtils.toString(((ChatRequestSystemMessage)message).getContent()), null, null, null, null, null);
                }
                if (message instanceof ChatRequestAssistantMessage) {
                    try {
                        List<OpenAIFunctionToolCall> calls = this.getToolCalls(((ChatRequestAssistantMessage)message).getToolCalls());
                        return new OpenAIChatMessageContent<Object>(AuthorRole.ASSISTANT, BinaryDataUtils.toString(((ChatRequestAssistantMessage)message).getContent()), null, null, null, null, calls);
                    }
                    catch (SKCheckedException e) {
                        throw SKException.build((String)"Failed to form assistant message", (Exception)((Object)e));
                    }
                }
                if (message instanceof ChatRequestToolMessage) {
                    return new OpenAIChatMessageContent<Object>(AuthorRole.TOOL, BinaryDataUtils.toString(((ChatRequestToolMessage)message).getContent()), null, null, null, FunctionResultMetadata.build((String)((ChatRequestToolMessage)message).getToolCallId(), null, null), null);
                }
                throw new SKException("Unknown message type: " + message.getClass().getSimpleName());
            }).collect(Collectors.toList());
        }
        catch (SKException e) {
            throw SKCheckedException.build((String)"Failed to form OpenAI chat message content", (Exception)((Object)e));
        }
    }

    @Nullable
    private List<OpenAIFunctionToolCall> getToolCalls(@Nullable List<ChatCompletionsToolCall> toolCalls) throws SKCheckedException {
        if (toolCalls == null || toolCalls.isEmpty()) {
            return null;
        }
        try {
            return toolCalls.stream().map(call -> {
                if (call instanceof ChatCompletionsFunctionToolCall) {
                    try {
                        return this.extractOpenAIFunctionToolCall((ChatCompletionsFunctionToolCall)call);
                    }
                    catch (JsonProcessingException e) {
                        throw SKException.build((String)"Failed to parse tool arguments", (Exception)((Object)e));
                    }
                }
                throw new SKException("Unknown tool call type: " + call.getClass().getSimpleName());
            }).collect(Collectors.toList());
        }
        catch (SKException e) {
            throw SKCheckedException.build((String)"Failed to form tool call", (Exception)((Object)e));
        }
    }

    @Nullable
    private List<OpenAIFunctionToolCall> formOpenAiToolCalls(ChatResponseMessage response) throws SKCheckedException {
        if (response.getToolCalls() == null || response.getToolCalls().isEmpty()) {
            return null;
        }
        try {
            return response.getToolCalls().stream().map(call -> {
                if (call instanceof ChatCompletionsFunctionToolCall) {
                    try {
                        return this.extractOpenAIFunctionToolCall((ChatCompletionsFunctionToolCall)call);
                    }
                    catch (JsonProcessingException e) {
                        throw SKException.build((String)"Failed to parse tool arguments", (Exception)((Object)e));
                    }
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (SKException e) {
            throw SKCheckedException.build((String)"Failed to form tool call", (Exception)((Object)e));
        }
    }

    private static ChatCompletionsOptions getCompletionsOptions(ChatCompletionService chatCompletionService, List<ChatRequestMessage> chatRequestMessages, @Nullable List<OpenAIFunction> functions, @Nullable InvocationContext invocationContext) {
        PromptExecutionSettings promptExecutionSettings;
        chatRequestMessages = chatRequestMessages.stream().map(OpenAiXMLPromptParser::unescapeRequest).collect(Collectors.toList());
        ChatCompletionsOptions options = new ChatCompletionsOptions(chatRequestMessages).setModel(chatCompletionService.getModelId());
        if (invocationContext != null && invocationContext.getToolCallBehavior() != null) {
            OpenAIChatCompletion.configureToolCallBehaviorOptions(options, invocationContext.getToolCallBehavior(), functions, chatRequestMessages);
        }
        PromptExecutionSettings promptExecutionSettings2 = promptExecutionSettings = invocationContext != null ? invocationContext.getPromptExecutionSettings() : null;
        if (promptExecutionSettings == null) {
            return options;
        }
        if (promptExecutionSettings.getResultsPerPrompt() < 1 || promptExecutionSettings.getResultsPerPrompt() > 128) {
            throw new AIException(AIException.ErrorCodes.INVALID_REQUEST, String.format("Results per prompt must be in range between 1 and %d, inclusive.", 128));
        }
        Map<String, Integer> logit = null;
        if (promptExecutionSettings.getTokenSelectionBiases() != null) {
            logit = promptExecutionSettings.getTokenSelectionBiases().entrySet().stream().collect(Collectors.toMap(entry -> ((Integer)entry.getKey()).toString(), Map.Entry::getValue));
        }
        options.setTemperature(Double.valueOf(promptExecutionSettings.getTemperature())).setTopP(Double.valueOf(promptExecutionSettings.getTopP())).setPresencePenalty(Double.valueOf(promptExecutionSettings.getPresencePenalty())).setFrequencyPenalty(Double.valueOf(promptExecutionSettings.getFrequencyPenalty())).setPresencePenalty(Double.valueOf(promptExecutionSettings.getPresencePenalty())).setMaxTokens(Integer.valueOf(promptExecutionSettings.getMaxTokens())).setN(Integer.valueOf(promptExecutionSettings.getResultsPerPrompt())).setStop(promptExecutionSettings.getStopSequences() == null || promptExecutionSettings.getStopSequences().isEmpty() ? null : promptExecutionSettings.getStopSequences()).setUser(promptExecutionSettings.getUser()).setLogitBias(logit);
        if (promptExecutionSettings.getResponseFormat() != null) {
            switch (promptExecutionSettings.getResponseFormat().getType()) {
                case JSON_SCHEMA: {
                    JsonResponseSchema schema = ((JsonSchemaResponseFormat)promptExecutionSettings.getResponseFormat()).getJsonSchema();
                    options.setResponseFormat((ChatCompletionsResponseFormat)new ChatCompletionsJsonSchemaResponseFormat(schema));
                    break;
                }
                case JSON_OBJECT: {
                    options.setResponseFormat((ChatCompletionsResponseFormat)new ChatCompletionsJsonResponseFormat());
                    break;
                }
                case TEXT: {
                    options.setResponseFormat((ChatCompletionsResponseFormat)new ChatCompletionsTextResponseFormat());
                    break;
                }
                default: {
                    throw new SKException("Unknown response format: " + promptExecutionSettings.getResponseFormat());
                }
            }
        }
        return options;
    }

    private static void configureToolCallBehaviorOptions(ChatCompletionsOptions options, @Nullable ToolCallBehavior toolCallBehavior, @Nullable List<OpenAIFunction> functions, List<ChatRequestMessage> chatRequestMessages) {
        if (toolCallBehavior == null) {
            return;
        }
        if (functions == null || functions.isEmpty()) {
            return;
        }
        if (toolCallBehavior instanceof ToolCallBehavior.RequiredKernelFunction) {
            KernelFunction toolChoice = ((ToolCallBehavior.RequiredKernelFunction)toolCallBehavior).getRequiredFunction();
            String toolChoiceName = String.format("%s%s%s", toolChoice.getPluginName(), OpenAIFunction.getNameSeparator(), toolChoice.getName());
            boolean hasBeenExecuted = OpenAIChatCompletion.hasToolCallBeenExecuted(chatRequestMessages, toolChoiceName);
            if (hasBeenExecuted) {
                return;
            }
            ArrayList<ChatCompletionsFunctionToolDefinition> toolDefinitions = new ArrayList<ChatCompletionsFunctionToolDefinition>();
            FunctionDefinition function2 = OpenAIFunction.toFunctionDefinition(toolChoice.getMetadata(), toolChoice.getPluginName());
            toolDefinitions.add(new ChatCompletionsFunctionToolDefinition(new ChatCompletionsFunctionToolDefinitionFunction(function2.getName()).setDescription(function2.getDescription()).setParameters(function2.getParameters())));
            options.setTools(toolDefinitions);
            try {
                String json = String.format("{\"type\":\"function\",\"function\":{\"name\":\"%s\"}}", toolChoiceName);
                options.setToolChoice(new ChatCompletionsToolSelection(ChatCompletionsNamedToolSelection.fromJson((JsonReader)DefaultJsonReader.fromString((String)json, (JsonOptions)new JsonOptions()))));
            }
            catch (JsonProcessingException e) {
                throw SKException.build((String)"Failed to parse tool choice", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new SKException((Throwable)e);
            }
            return;
        }
        ToolCallBehavior.AllowedKernelFunctions enabledKernelFunctions = (ToolCallBehavior.AllowedKernelFunctions)toolCallBehavior;
        List toolDefinitions = functions.stream().filter(function -> {
            if (enabledKernelFunctions.isAllKernelFunctionsAllowed()) {
                return true;
            }
            return enabledKernelFunctions.isFunctionAllowed(function.getPluginName(), function.getName());
        }).map(OpenAIFunction::getFunctionDefinition).map(it -> new ChatCompletionsFunctionToolDefinitionFunction(it.getName()).setDescription(it.getDescription()).setParameters(it.getParameters())).map(it -> new ChatCompletionsFunctionToolDefinition(it)).collect(Collectors.toList());
        if (toolDefinitions.isEmpty()) {
            return;
        }
        options.setTools(toolDefinitions);
        options.setToolChoice(new ChatCompletionsToolSelection(ChatCompletionsToolSelectionPreset.AUTO));
    }

    private static boolean hasToolCallBeenExecuted(List<ChatRequestMessage> chatRequestMessages, String toolChoiceName) {
        return chatRequestMessages.stream().flatMap(message -> {
            if (message instanceof ChatRequestAssistantMessage) {
                return ((ChatRequestAssistantMessage)message).getToolCalls().stream();
            }
            return Stream.empty();
        }).filter(toolCall -> {
            if (toolCall instanceof ChatCompletionsFunctionToolCall) {
                return ((ChatCompletionsFunctionToolCall)toolCall).getFunction().getName().equals(toolChoiceName);
            }
            return false;
        }).allMatch(toolcall -> {
            String id = toolcall.getId();
            return chatRequestMessages.stream().filter(chatRequestMessage -> chatRequestMessage instanceof ChatRequestToolMessage).anyMatch(chatRequestMessage -> ((ChatRequestToolMessage)chatRequestMessage).getToolCallId().equals(id));
        });
    }

    private static List<ChatRequestMessage> getChatRequestMessages(List<? extends ChatMessageContent<?>> messages) {
        if (messages == null || messages.isEmpty()) {
            return new ArrayList<ChatRequestMessage>();
        }
        return messages.stream().map(OpenAIChatCompletion::getChatRequestMessage).collect(Collectors.toList());
    }

    private static List<ChatRequestMessage> getChatRequestMessages(ChatHistory chatHistory) {
        return OpenAIChatCompletion.getChatRequestMessages(chatHistory.getMessages());
    }

    private static ChatRequestMessage getChatRequestMessage(ChatMessageContent<?> message) {
        AuthorRole authorRole = message.getAuthorRole();
        String content = message.getContent();
        if (message.getContentType() == ChatMessageContentType.IMAGE_URL && content != null) {
            return OpenAIChatCompletion.formImageMessage(message, content);
        }
        switch (authorRole) {
            case ASSISTANT: {
                return OpenAIChatCompletion.formAssistantMessage(message, content);
            }
            case SYSTEM: {
                return new ChatRequestSystemMessage(content);
            }
            case USER: {
                return new ChatRequestUserMessage(content);
            }
            case TOOL: {
                String id = null;
                if (message.getMetadata() != null) {
                    id = message.getMetadata().getId();
                }
                if (id == null) {
                    throw new SKException("Require to create a tool call message, but no tool call id is available");
                }
                return new ChatRequestToolMessage(content, id);
            }
        }
        LOGGER.debug("Unexpected author role: {}", (Object)authorRole);
        throw new SKException("Unexpected author role: " + authorRole);
    }

    private static ChatRequestUserMessage formImageMessage(ChatMessageContent<?> message, String content) {
        ChatMessageImageUrl imageUrl = new ChatMessageImageUrl(content);
        if (message instanceof ChatMessageImageContent) {
            ChatMessageImageDetailLevel detail = ChatMessageImageDetailLevel.fromString((String)((ChatMessageImageContent)message).getDetail().toString());
            imageUrl.setDetail(detail);
        }
        return new ChatRequestUserMessage(Collections.singletonList(new ChatMessageImageContentItem(imageUrl)));
    }

    private static ChatRequestAssistantMessage formAssistantMessage(ChatMessageContent<?> message, @Nullable String content) {
        ChatRequestAssistantMessage asstMessage = new ChatRequestAssistantMessage(content);
        List<OpenAIFunctionToolCall> toolCalls = null;
        if (message instanceof OpenAIChatMessageContent) {
            toolCalls = ((OpenAIChatMessageContent)message).getToolCall();
        }
        if (toolCalls != null) {
            asstMessage.setToolCalls(toolCalls.stream().map(toolCall -> {
                KernelFunctionArguments arguments = toolCall.getArguments();
                String args = arguments != null && !arguments.isEmpty() ? arguments.entrySet().stream().map(entry -> String.format("\"%s\": \"%s\"", StringEscapeUtils.escapeJson((String)((String)entry.getKey())), StringEscapeUtils.escapeJson((String)((ContextVariable)entry.getValue()).toPromptString()))).collect(Collectors.joining(",", "{", "}")) : "{}";
                String prefix = "";
                if (toolCall.getPluginName() != null) {
                    prefix = toolCall.getPluginName() + OpenAIFunction.getNameSeparator();
                }
                String name = prefix + toolCall.getFunctionName();
                FunctionCall fnCall = new FunctionCall(name, args);
                return new ChatCompletionsFunctionToolCall(toolCall.getId(), fnCall);
            }).collect(Collectors.toList()));
        }
        return asstMessage;
    }

    static ChatRequestMessage getChatRequestMessage(AuthorRole authorRole, String content) {
        switch (authorRole) {
            case ASSISTANT: {
                return new ChatRequestAssistantMessage(content);
            }
            case SYSTEM: {
                return new ChatRequestSystemMessage(content);
            }
            case USER: {
                return new ChatRequestUserMessage(content);
            }
            case TOOL: {
                return new ChatRequestToolMessage(content, null);
            }
        }
        LOGGER.debug("Unexpected author role: " + authorRole);
        throw new SKException("Unexpected author role: " + authorRole);
    }

    public static class Builder
    extends OpenAiServiceBuilder<OpenAIAsyncClient, OpenAIChatCompletion, Builder> {
        public OpenAIChatCompletion build() {
            if (this.client == null) {
                throw new AIException(AIException.ErrorCodes.INVALID_REQUEST, "OpenAI client must be provided");
            }
            if (this.modelId == null || this.modelId.isEmpty()) {
                throw new AIException(AIException.ErrorCodes.INVALID_REQUEST, "OpenAI model id must be provided");
            }
            if (this.deploymentName == null) {
                LOGGER.debug("Deployment name is not provided, using model id as deployment name");
                this.deploymentName = this.modelId;
            }
            return new OpenAIChatCompletion((OpenAIAsyncClient)this.client, this.deploymentName, this.modelId, this.serviceId);
        }
    }

    private static class FunctionInvocationError
    extends SKException {
        private final List<ChatRequestMessage> messages;

        public FunctionInvocationError(Throwable e, List<ChatRequestMessage> msgs) {
            super(e.getMessage(), e);
            this.messages = msgs;
        }

        public List<ChatRequestMessage> getMessages() {
            return this.messages;
        }
    }

    private static class ChatMessages {
        private final List<ChatRequestMessage> newMessages;
        private final List<ChatRequestMessage> allMessages;
        private final List<OpenAIChatMessageContent<?>> newChatMessageContent;

        public ChatMessages(List<ChatRequestMessage> allMessages) {
            this.allMessages = Collections.unmodifiableList(allMessages);
            this.newMessages = Collections.unmodifiableList(new ArrayList());
            this.newChatMessageContent = Collections.unmodifiableList(new ArrayList());
        }

        private ChatMessages(List<ChatRequestMessage> allMessages, List<ChatRequestMessage> newMessages, List<OpenAIChatMessageContent<?>> newChatMessageContent) {
            this.allMessages = Collections.unmodifiableList(allMessages);
            this.newMessages = Collections.unmodifiableList(newMessages);
            this.newChatMessageContent = Collections.unmodifiableList(newChatMessageContent);
        }

        @CheckReturnValue
        public ChatMessages addAll(List<ChatRequestMessage> requestMessage) {
            ArrayList<ChatRequestMessage> tmpAllMessages = new ArrayList<ChatRequestMessage>(this.allMessages);
            ArrayList<ChatRequestMessage> tmpNewMessages = new ArrayList<ChatRequestMessage>(this.newMessages);
            tmpAllMessages.addAll(requestMessage);
            tmpNewMessages.addAll(requestMessage);
            return new ChatMessages(tmpAllMessages, tmpNewMessages, this.newChatMessageContent);
        }

        @CheckReturnValue
        public ChatMessages add(ChatRequestMessage requestMessage) {
            return this.addAll(Arrays.asList(requestMessage));
        }

        @CheckReturnValue
        public ChatMessages addChatMessage(List<OpenAIChatMessageContent<?>> chatMessageContent) {
            ArrayList tmpChatMessageContent = new ArrayList(this.newChatMessageContent);
            tmpChatMessageContent.addAll(chatMessageContent);
            return new ChatMessages(this.allMessages, this.newMessages, tmpChatMessageContent);
        }

        boolean assertCommonHistory(List<ChatRequestMessage> messages) {
            for (int index = 0; index < messages.size() && index < this.allMessages.size(); ++index) {
                ChatRequestMessage a = messages.get(index);
                ChatRequestMessage b = this.allMessages.get(index);
                boolean matches = false;
                if (a instanceof ChatRequestAssistantMessage && b instanceof ChatRequestAssistantMessage) {
                    matches = Objects.equals(((ChatRequestAssistantMessage)a).getContent(), ((ChatRequestAssistantMessage)b).getContent());
                } else if (a instanceof ChatRequestSystemMessage && b instanceof ChatRequestSystemMessage) {
                    matches = Objects.equals(((ChatRequestSystemMessage)a).getContent(), ((ChatRequestSystemMessage)b).getContent());
                } else if (a instanceof ChatRequestUserMessage && b instanceof ChatRequestUserMessage) {
                    matches = Objects.equals(((ChatRequestUserMessage)a).getContent(), ((ChatRequestUserMessage)b).getContent());
                } else if (a instanceof ChatRequestFunctionMessage && b instanceof ChatRequestFunctionMessage) {
                    matches = Objects.equals(((ChatRequestFunctionMessage)a).getContent(), ((ChatRequestFunctionMessage)b).getContent());
                } else if (a instanceof ChatRequestToolMessage && b instanceof ChatRequestToolMessage) {
                    matches = Objects.equals(((ChatRequestToolMessage)a).getContent(), ((ChatRequestToolMessage)b).getContent());
                }
                if (matches) continue;
                LOGGER.warn("Messages do not match at index: " + index + " you might be merging unrelated message histories");
                return false;
            }
            return true;
        }
    }
}

