/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.chatcompletion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class ChatHistory {
    private final List<Message> messages = new ArrayList<Message>();

    public List<Message> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public Optional<Message> getLastMessage() {
        if (this.messages.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.messages.get(this.messages.size() - 1));
    }

    public void addMessage(AuthorRoles authorRole, String content) {
        this.messages.add(new Message(authorRole, content));
    }

    public static class Message {
        private final AuthorRoles authorRoles;
        private final String content;

        public Message(AuthorRoles authorRoles, String content) {
            this.authorRoles = authorRoles;
            this.content = content;
        }

        public AuthorRoles getAuthorRoles() {
            return this.authorRoles;
        }

        public String getContent() {
            return this.content;
        }
    }

    public static enum AuthorRoles {
        Unknown,
        System,
        User,
        Assistant;

    }
}

