/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.orchestration;

import com.microsoft.semantickernel.SKBuilders;
import com.microsoft.semantickernel.memory.SemanticTextMemory;
import com.microsoft.semantickernel.orchestration.ContextVariables;
import com.microsoft.semantickernel.orchestration.SKContext;
import com.microsoft.semantickernel.orchestration.WritableContextVariables;
import com.microsoft.semantickernel.skilldefinition.ReadOnlySkillCollection;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractSKContext
implements SKContext {
    private final ReadOnlySkillCollection skills;
    private final WritableContextVariables variables;
    @Nullable
    private final SemanticTextMemory memory;
    private boolean errorOccurred;
    private String lastErrorDescription = "";
    @Nullable
    private Exception lastException;

    @Override
    @Nullable
    public String getResult() {
        return this.getVariables().asMap().get("input");
    }

    @Override
    public ContextVariables getVariables() {
        return (ContextVariables)SKBuilders.variables().withVariables(this.variables.asMap()).build();
    }

    AbstractSKContext(ContextVariables variables) {
        this(variables, null, null);
    }

    protected AbstractSKContext(ContextVariables variables, @Nullable SemanticTextMemory memory, @Nullable ReadOnlySkillCollection skills) {
        this.variables = ((ContextVariables)SKBuilders.variables().withVariables(variables.asMap()).build()).writableClone();
        this.memory = memory != null ? memory.copy() : null;
        this.skills = skills == null ? (ReadOnlySkillCollection)SKBuilders.skillCollection().build() : skills;
    }

    protected AbstractSKContext(SKContext toClone, String errorDescription, Exception exception) {
        this(toClone.getVariables(), toClone.getSemanticMemory(), toClone.getSkills());
        this.errorOccurred = true;
        this.lastErrorDescription = errorDescription;
        this.lastException = exception;
    }

    @Override
    @CheckReturnValue
    public SKContext copy() {
        ReadOnlySkillCollection clonedSkill = this.skills == null ? null : this.skills.copy();
        return this.build(this.variables.writableClone(), this.memory, clonedSkill);
    }

    @Override
    @Nullable
    public SemanticTextMemory getSemanticMemory() {
        return this.memory != null ? this.memory.copy() : null;
    }

    @Override
    public ReadOnlySkillCollection getSkills() {
        return this.skills;
    }

    @Override
    public SKContext setVariable(@Nonnull String key, @Nonnull String content) {
        this.variables.setVariable(key, content);
        return this.getThis();
    }

    @Override
    public SKContext appendToVariable(@Nonnull String key, @Nonnull String content) {
        this.variables.appendToVariable(key, content);
        return this.getThis();
    }

    @Override
    public SKContext update(@Nonnull String content) {
        this.variables.update(content);
        return this.getThis();
    }

    @Override
    public SKContext update(@Nonnull ContextVariables newData) {
        this.variables.update(newData, true);
        return this.getThis();
    }

    protected abstract SKContext getThis();

    public boolean isErrorOccurred() {
        return this.errorOccurred;
    }

    public String getLastErrorDescription() {
        return this.lastErrorDescription;
    }

    @Nullable
    public Exception getLastException() {
        return new Exception(this.lastException);
    }
}

