/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.textcompletion;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.semantickernel.ai.AIRequestSettings;
import com.microsoft.semantickernel.builders.Buildable;
import com.microsoft.semantickernel.builders.SemanticKernelBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CompletionRequestSettings
extends AIRequestSettings
implements Buildable {
    private final double temperature;
    private final double topP;
    private final double presencePenalty;
    private final double frequencyPenalty;
    private final int maxTokens;
    private final List<String> stopSequences;
    private final int bestOf;
    private final String user;

    public CompletionRequestSettings(double temperature, double topP, double presencePenalty, double frequencyPenalty, int maxTokens) {
        this(temperature, topP, presencePenalty, frequencyPenalty, maxTokens, 1, "", Collections.emptyList(), null, null);
    }

    public CompletionRequestSettings(@JsonProperty(value="temperature") double temperature, @JsonProperty(value="top_p") double topP, @JsonProperty(value="presence_penalty") double presencePenalty, @JsonProperty(value="frequency_penalty") double frequencyPenalty, @JsonProperty(value="max_tokens") int maxTokens, @JsonProperty(value="best_of") int bestOf, @JsonProperty(value="user") String user, @JsonProperty(value="stop_sequences") List<String> stopSequences, @JsonProperty(value="service_id") @Nullable String serviceId, @JsonProperty(value="model_id") @Nullable String modelId) {
        super(serviceId, modelId);
        this.temperature = temperature;
        this.topP = topP;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.maxTokens = maxTokens;
        this.bestOf = Math.max(1, bestOf);
        if (user == null) {
            user = "";
        }
        this.user = user;
        if (stopSequences == null) {
            stopSequences = new ArrayList<String>();
        }
        this.stopSequences = stopSequences;
    }

    public CompletionRequestSettings() {
        this(0.0, 0.0, 0.0, 0.0, 256, 1, "", new ArrayList<String>(), null, null);
    }

    public CompletionRequestSettings(@Nonnull CompletionRequestSettings requestSettings) {
        this(requestSettings.getTemperature(), requestSettings.getTopP(), requestSettings.getPresencePenalty(), requestSettings.getFrequencyPenalty(), requestSettings.getMaxTokens(), requestSettings.getBestOf(), requestSettings.getUser(), requestSettings.getStopSequences(), requestSettings.getServiceId(), requestSettings.getModelId());
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getTopP() {
        return this.topP;
    }

    public double getPresencePenalty() {
        return this.presencePenalty;
    }

    public double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public List<String> getStopSequences() {
        return Collections.unmodifiableList(this.stopSequences);
    }

    public Integer getBestOf() {
        return this.bestOf;
    }

    public String getUser() {
        return this.user;
    }

    public static class Builder
    implements SemanticKernelBuilder<CompletionRequestSettings> {
        private final CompletionRequestSettings completionConfig;

        public Builder() {
            this.completionConfig = new CompletionRequestSettings();
        }

        public Builder(CompletionRequestSettings completionConfig) {
            this.completionConfig = completionConfig;
        }

        public Builder temperature(double temperature) {
            return new Builder(new CompletionRequestSettings(temperature, this.completionConfig.topP, this.completionConfig.presencePenalty, this.completionConfig.frequencyPenalty, this.completionConfig.maxTokens, this.completionConfig.bestOf, this.completionConfig.user, this.completionConfig.stopSequences, this.completionConfig.getServiceId(), this.completionConfig.getModelId()));
        }

        public Builder topP(double topP) {
            return new Builder(new CompletionRequestSettings(this.completionConfig.temperature, topP, this.completionConfig.presencePenalty, this.completionConfig.frequencyPenalty, this.completionConfig.maxTokens, this.completionConfig.bestOf, this.completionConfig.user, this.completionConfig.stopSequences, this.completionConfig.getServiceId(), this.completionConfig.getModelId()));
        }

        public Builder presencePenalty(double presencePenalty) {
            return new Builder(new CompletionRequestSettings(this.completionConfig.temperature, this.completionConfig.topP, presencePenalty, this.completionConfig.frequencyPenalty, this.completionConfig.maxTokens, this.completionConfig.bestOf, this.completionConfig.user, this.completionConfig.stopSequences, this.completionConfig.getServiceId(), this.completionConfig.getModelId()));
        }

        public Builder frequencyPenalty(double frequencyPenalty) {
            return new Builder(new CompletionRequestSettings(this.completionConfig.temperature, this.completionConfig.topP, this.completionConfig.presencePenalty, frequencyPenalty, this.completionConfig.maxTokens, this.completionConfig.bestOf, this.completionConfig.user, this.completionConfig.stopSequences, this.completionConfig.getServiceId(), this.completionConfig.getModelId()));
        }

        public Builder maxTokens(int maxTokens) {
            return new Builder(new CompletionRequestSettings(this.completionConfig.temperature, this.completionConfig.topP, this.completionConfig.presencePenalty, this.completionConfig.frequencyPenalty, maxTokens, this.completionConfig.bestOf, this.completionConfig.user, this.completionConfig.stopSequences, this.completionConfig.getServiceId(), this.completionConfig.getModelId()));
        }

        public Builder bestOf(int bestOf) {
            return new Builder(new CompletionRequestSettings(this.completionConfig.temperature, this.completionConfig.topP, this.completionConfig.presencePenalty, this.completionConfig.frequencyPenalty, this.completionConfig.maxTokens, bestOf, this.completionConfig.user, this.completionConfig.stopSequences, this.completionConfig.getServiceId(), this.completionConfig.getModelId()));
        }

        public Builder user(String user) {
            return new Builder(new CompletionRequestSettings(this.completionConfig.temperature, this.completionConfig.topP, this.completionConfig.presencePenalty, this.completionConfig.frequencyPenalty, this.completionConfig.maxTokens, this.completionConfig.bestOf, user, this.completionConfig.stopSequences, this.completionConfig.getServiceId(), this.completionConfig.getModelId()));
        }

        public Builder stopSequences(List<String> stopSequences) {
            return new Builder(new CompletionRequestSettings(this.completionConfig.temperature, this.completionConfig.topP, this.completionConfig.presencePenalty, this.completionConfig.frequencyPenalty, this.completionConfig.maxTokens, this.completionConfig.bestOf, this.completionConfig.user, stopSequences, this.completionConfig.getServiceId(), this.completionConfig.getModelId()));
        }

        public Builder serviceId(String serviceId) {
            return new Builder(new CompletionRequestSettings(this.completionConfig.temperature, this.completionConfig.topP, this.completionConfig.presencePenalty, this.completionConfig.frequencyPenalty, this.completionConfig.maxTokens, this.completionConfig.bestOf, this.completionConfig.user, this.completionConfig.stopSequences, serviceId, this.completionConfig.getModelId()));
        }

        public Builder modelId(String modelId) {
            return new Builder(new CompletionRequestSettings(this.completionConfig.temperature, this.completionConfig.topP, this.completionConfig.presencePenalty, this.completionConfig.frequencyPenalty, this.completionConfig.maxTokens, this.completionConfig.bestOf, this.completionConfig.user, this.completionConfig.stopSequences, this.completionConfig.getServiceId(), modelId));
        }

        @Override
        public CompletionRequestSettings build() {
            return this.completionConfig;
        }
    }
}

