// Copyright (c) Microsoft. All rights reserved.
package com.microsoft.semantickernel.textcompletion;

import com.azure.ai.openai.OpenAIAsyncClient;
import com.microsoft.semantickernel.services.AIService;

import reactor.core.publisher.Mono;

import java.util.List;

/** Interface for text completion services */
public interface TextCompletion extends AIService {
    // TODO: Support Cancellation Token

    /**
     * Creates a completion for the prompt and settings.
     *
     * @param text The prompt to complete.
     * @param requestSettings Request settings for the completion API
     * @return Text generated by the remote model
     */
    Mono<List<String>> completeAsync(String text, CompletionRequestSettings requestSettings);

    abstract class Builder {
        protected Builder() {}

        public abstract TextCompletion build(OpenAIAsyncClient client, String modelId);
    }
}
