/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel;

import com.microsoft.semantickernel.KernelConfig;
import com.microsoft.semantickernel.KernelException;
import com.microsoft.semantickernel.SkillExecutor;
import com.microsoft.semantickernel.builders.BuildersSingleton;
import com.microsoft.semantickernel.memory.MemoryStore;
import com.microsoft.semantickernel.memory.SemanticTextMemory;
import com.microsoft.semantickernel.orchestration.ContextVariables;
import com.microsoft.semantickernel.orchestration.SKContext;
import com.microsoft.semantickernel.orchestration.SKFunction;
import com.microsoft.semantickernel.services.AIService;
import com.microsoft.semantickernel.services.AIServiceCollection;
import com.microsoft.semantickernel.services.AIServiceProvider;
import com.microsoft.semantickernel.templateengine.PromptTemplateEngine;
import com.microsoft.semantickernel.textcompletion.CompletionSKFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import reactor.core.publisher.Mono;

public interface Kernel
extends SkillExecutor {
    public KernelConfig getConfig();

    public PromptTemplateEngine getPromptTemplateEngine();

    public SemanticTextMemory getMemory();

    public Mono<SKContext> runAsync(SKFunction<?> ... var1);

    public Mono<SKContext> runAsync(String var1, SKFunction<?> ... var2);

    public Mono<SKContext> runAsync(ContextVariables var1, SKFunction<?> ... var2);

    public CompletionSKFunction.Builder getSemanticFunctionBuilder();

    public <T extends AIService> T getService(@Nullable String var1, Class<T> var2) throws KernelException;

    public <RequestConfiguration, FunctionType extends SKFunction<RequestConfiguration>> FunctionType registerSemanticFunction(FunctionType var1);

    public SKFunction getFunction(String var1, String var2);

    public static interface InternalBuilder {
        public Kernel build(KernelConfig var1, @Nullable PromptTemplateEngine var2, @Nullable SemanticTextMemory var3, @Nullable MemoryStore var4, @Nullable AIServiceProvider var5);
    }

    public static class Builder {
        @Nullable
        private KernelConfig kernelConfig = null;
        @Nullable
        private PromptTemplateEngine promptTemplateEngine = null;
        @Nullable
        private MemoryStore memoryStore = null;
        @Nullable
        private AIServiceCollection aiServices = new AIServiceCollection();
        @Nullable
        private SemanticTextMemory memory = null;

        public Builder withKernelConfig(KernelConfig kernelConfig) {
            this.kernelConfig = kernelConfig;
            return this;
        }

        public Builder withPromptTemplateEngine(PromptTemplateEngine promptTemplateEngine) {
            this.promptTemplateEngine = promptTemplateEngine;
            return this;
        }

        public Builder withMemoryStore(MemoryStore memoryStore) {
            this.memoryStore = memoryStore;
            return this;
        }

        public <T extends AIService> Builder withDefaultAIService(T instance, Class<T> clazz) {
            this.aiServices.setService(instance, clazz);
            return this;
        }

        public <T extends AIService> Builder withAIService(@Nullable String serviceId, T instance, boolean setAsDefault, Class<T> clazz) {
            this.aiServices.setService(serviceId, instance, setAsDefault, clazz);
            return this;
        }

        public <T extends AIService> Builder withDefaultAIService(Supplier<T> factory, Class<T> clazz) {
            this.aiServices.setService(factory, clazz);
            return this;
        }

        public <T extends AIService> Builder withAIService(@Nullable String serviceId, Function<KernelConfig, T> factory, boolean setAsDefault, Class<T> clazz) {
            this.aiServices.setService(serviceId, () -> (AIService)factory.apply(this.kernelConfig), setAsDefault, clazz);
            return this;
        }

        public Builder withMemory(SemanticTextMemory memory) {
            this.memory = memory;
            return this;
        }

        public Kernel build() {
            if (this.kernelConfig == null) {
                throw new IllegalStateException("Must provide a kernel configuration");
            }
            return BuildersSingleton.INST.getKernelBuilder().build(this.kernelConfig, this.promptTemplateEngine, this.memory, this.memoryStore, this.aiServices.build());
        }
    }
}

