/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.ai.embeddings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Embedding<EmbeddingType extends Number> {
    private final List<EmbeddingType> vector;
    private static final Embedding<Number> EMPTY = new Embedding(Collections.unmodifiableList(new ArrayList()));

    public List<EmbeddingType> getVector() {
        return Collections.unmodifiableList(this.vector);
    }

    public static <EmbeddingType extends Number> Embedding<EmbeddingType> empty() {
        return EMPTY;
    }

    public Embedding() {
        this.vector = Collections.emptyList();
    }

    public Embedding(List<EmbeddingType> vector) {
        this.vector = vector != null ? Collections.unmodifiableList(vector) : Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Embedding)) {
            return false;
        }
        Embedding embedding = (Embedding)o;
        return this.vector.equals(embedding.vector);
    }

    public int hashCode() {
        return this.vector.hashCode();
    }

    public String toString() {
        return "Embedding{vector=" + this.vector.stream().limit(3L).map(String::valueOf).collect(Collectors.joining(", ", "[", this.vector.size() > 3 ? "...]" : "]")) + '}';
    }
}

