/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.extensions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.semantickernel.KernelException;
import com.microsoft.semantickernel.builders.SKBuilders;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplate;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplateConfig;
import com.microsoft.semantickernel.semanticfunctions.SemanticFunctionConfig;
import com.microsoft.semantickernel.templateengine.PromptTemplateEngine;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KernelExtensions {
    private static final Logger LOGGER = LoggerFactory.getLogger(KernelExtensions.class);

    private KernelExtensions() {
    }

    public static Map<String, SemanticFunctionConfig> importSemanticSkillFromDirectory(String parentDirectory, String skillDirectoryName, PromptTemplateEngine promptTemplateEngine) {
        String CONFIG_FILE = "config.json";
        String PROMPT_FILE = "skprompt.txt";
        File skillDir = new File(parentDirectory, skillDirectoryName);
        File[] files = skillDir.listFiles();
        if (files == null) {
            throw new KernelException(KernelException.ErrorCodes.FunctionNotAvailable, "No Skills found in directory " + skillDir.getAbsolutePath());
        }
        HashMap<String, SemanticFunctionConfig> skills = new HashMap<String, SemanticFunctionConfig>();
        for (File dir : files) {
            try {
                File promptPath = new File(dir, PROMPT_FILE);
                if (!promptPath.exists()) continue;
                PromptTemplateConfig config = new PromptTemplateConfig("", "", null);
                File configPath = new File(dir, CONFIG_FILE);
                if (configPath.exists()) {
                    config = (PromptTemplateConfig)new ObjectMapper().readValue(configPath, PromptTemplateConfig.class);
                }
                String template = new String(Files.readAllBytes(promptPath.toPath()), Charset.defaultCharset());
                PromptTemplate promptTemplate = SKBuilders.promptTemplate().withPromptTemplate(template).withPromptTemplateConfig(config).build(promptTemplateEngine);
                skills.put(dir.getName(), new SemanticFunctionConfig(config, promptTemplate));
            }
            catch (IOException e) {
                LOGGER.error("Failed to read file", (Throwable)e);
            }
        }
        return skills;
    }
}

