/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.memory;

import com.microsoft.semantickernel.ai.embeddings.Embedding;
import com.microsoft.semantickernel.memory.DataEntryBase;
import com.microsoft.semantickernel.memory.MemoryRecordMetadata;
import java.time.ZonedDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MemoryRecord
extends DataEntryBase {
    @Nonnull
    private final Embedding<? extends Number> embedding;
    @Nonnull
    private final MemoryRecordMetadata metadata;

    public MemoryRecord(@Nonnull MemoryRecordMetadata metadata, @Nonnull Embedding<? extends Number> embedding, @Nullable String key, @Nullable ZonedDateTime timestamp) {
        super(key, timestamp);
        this.metadata = metadata;
        this.embedding = embedding;
    }

    public Embedding<? extends Number> getEmbedding() {
        return this.embedding;
    }

    public MemoryRecordMetadata getMetadata() {
        return this.metadata;
    }

    public static MemoryRecord referenceRecord(@Nonnull String externalId, @Nonnull String sourceName, @Nullable String description, @Nonnull Embedding<Float> embedding, @Nullable String additionalMetadata, @Nullable String key, @Nullable ZonedDateTime timestamp) {
        MemoryRecordMetadata metadata = new MemoryRecordMetadata(true, externalId, "", description != null ? description : "", sourceName, additionalMetadata != null ? additionalMetadata : "");
        return new MemoryRecord(metadata, embedding, key, timestamp);
    }

    public static MemoryRecord localRecord(@Nonnull String id, @Nonnull String text, @Nullable String description, @Nonnull Embedding<Float> embedding, @Nullable String additionalMetadata, @Nullable String key, @Nullable ZonedDateTime timestamp) {
        boolean isReference = false;
        String emptyString = "";
        MemoryRecordMetadata metadata = new MemoryRecordMetadata(isReference, id, text, description != null ? description : emptyString, emptyString, additionalMetadata != null ? additionalMetadata : emptyString);
        return new MemoryRecord(metadata, embedding, key, timestamp);
    }

    public static MemoryRecord fromMetadata(@Nonnull MemoryRecordMetadata metadata, @Nullable Embedding<Float> embedding, @Nullable String key, @Nullable ZonedDateTime timestamp) {
        return new MemoryRecord(metadata, embedding != null ? embedding : Embedding.empty(), key, timestamp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MemoryRecord)) {
            return false;
        }
        MemoryRecord that = (MemoryRecord)o;
        if (!this.embedding.equals(that.embedding)) {
            return false;
        }
        return this.metadata.equals(that.metadata);
    }

    public int hashCode() {
        int result = this.embedding.hashCode();
        result = 31 * result + this.metadata.hashCode();
        return result;
    }

    public String toString() {
        return "MemoryRecord{embedding=" + this.embedding + ", metadata=" + this.metadata + '}';
    }
}

