/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.orchestration;

import com.microsoft.semantickernel.builders.SKBuilders;
import com.microsoft.semantickernel.memory.SemanticTextMemory;
import com.microsoft.semantickernel.orchestration.ContextVariables;
import com.microsoft.semantickernel.orchestration.InternalBuildersSingleton;
import com.microsoft.semantickernel.orchestration.SKContext;
import com.microsoft.semantickernel.orchestration.WritableContextVariables;
import com.microsoft.semantickernel.skilldefinition.ReadOnlySkillCollection;
import java.util.Collections;
import javax.annotation.CheckReturnValue;
import reactor.util.annotation.NonNull;
import reactor.util.annotation.Nullable;

public abstract class AbstractSKContext
implements SKContext {
    private final ReadOnlySkillCollection skills;
    private final WritableContextVariables variables;
    @Nullable
    private final SemanticTextMemory memory;

    @Override
    @Nullable
    public String getResult() {
        return this.getVariables().asMap().get("input");
    }

    @Override
    public ContextVariables getVariables() {
        return SKBuilders.variables().build(Collections.unmodifiableMap(this.variables.asMap()));
    }

    AbstractSKContext(ContextVariables variables) {
        this(variables, null, null);
    }

    protected AbstractSKContext(ContextVariables variables, @Nullable SemanticTextMemory memory, @Nullable ReadOnlySkillCollection skills) {
        this.variables = InternalBuildersSingleton.variables().build(variables.asMap());
        this.memory = memory != null ? memory.copy() : null;
        this.skills = skills == null ? SKBuilders.skillCollection().build() : skills;
    }

    @Override
    @CheckReturnValue
    public SKContext copy() {
        ReadOnlySkillCollection clonedSkill = this.skills == null ? null : this.skills.copy();
        return this.build(this.variables.writableClone(), this.memory, clonedSkill);
    }

    @Override
    @Nullable
    public SemanticTextMemory getSemanticMemory() {
        return this.memory != null ? this.memory.copy() : null;
    }

    @Override
    public ReadOnlySkillCollection getSkills() {
        return this.skills;
    }

    @Override
    public SKContext setVariable(@NonNull String key, @NonNull String content) {
        this.variables.setVariable(key, content);
        return this.getThis();
    }

    @Override
    public SKContext appendToVariable(@NonNull String key, @NonNull String content) {
        this.variables.appendToVariable(key, content);
        return this.getThis();
    }

    @Override
    public SKContext update(@NonNull String content) {
        this.variables.update(content);
        return this.getThis();
    }

    @Override
    public SKContext update(@NonNull ContextVariables newData) {
        this.variables.update(newData, true);
        return this.getThis();
    }

    protected abstract SKContext getThis();
}

