/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.semanticfunctions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import reactor.util.annotation.Nullable;

public class PromptTemplateConfig {
    private final CompletionConfig completionConfig;
    private final InputConfig input;
    private final int schema;
    private final String type;
    private final String description;

    public CompletionConfig getCompletionConfig() {
        return this.completionConfig;
    }

    public InputConfig getInput() {
        return this.input;
    }

    public PromptTemplateConfig() {
        this("", "", null);
    }

    public PromptTemplateConfig(CompletionConfig completionConfig) {
        this(1, "", "", completionConfig, new InputConfig(new ArrayList<InputParameter>()));
    }

    public PromptTemplateConfig(String description, String type, @Nullable CompletionConfig completionConfig) {
        this(1, description, type, completionConfig, new InputConfig(new ArrayList<InputParameter>()));
    }

    @JsonCreator
    public PromptTemplateConfig(@JsonProperty(value="schema") int schema, @JsonProperty(value="description") String description, @JsonProperty(value="type") String type, @Nullable @JsonProperty(value="completion") CompletionConfig completionConfig, @Nullable @JsonProperty(value="input") InputConfig input) {
        if (completionConfig == null) {
            completionConfig = new CompletionConfig();
        }
        this.schema = schema;
        this.description = description;
        this.type = type;
        this.completionConfig = completionConfig;
        if (input == null) {
            input = new InputConfig(new ArrayList<InputParameter>());
        }
        this.input = input;
    }

    public String getDescription() {
        return this.description;
    }

    public static class InputConfig {
        public final List<InputParameter> parameters;

        @JsonCreator
        public InputConfig(@JsonProperty(value="parameters") List<InputParameter> parameters) {
            this.parameters = Collections.unmodifiableList(parameters);
        }

        public List<InputParameter> getParameters() {
            return this.parameters;
        }
    }

    public static class InputParameter {
        private final String name;
        private final String description;
        private final String defaultValue;

        @JsonCreator
        public InputParameter(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="defaultValue") String defaultValue) {
            this.name = name;
            this.description = description;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }

    public static class CompletionConfig {
        private final double temperature;
        private final double topP;
        private final double presencePenalty;
        private final double frequencyPenalty;
        private final int maxTokens;
        public final List<String> stopSequences;
        private final Integer bestOf;
        private final String user;

        public CompletionConfig() {
            this(0.0, 0.0, 0.0, 0.0, 256, 1, "", new ArrayList<String>());
        }

        public CompletionConfig(double temperature, double topP, double presencePenalty, double frequencyPenalty, int maxTokens) {
            this(temperature, topP, presencePenalty, frequencyPenalty, maxTokens, 1, "", new ArrayList<String>());
        }

        @JsonCreator
        public CompletionConfig(@JsonProperty(value="temperature") double temperature, @JsonProperty(value="top_p") double topP, @JsonProperty(value="presence_penalty") double presencePenalty, @JsonProperty(value="frequency_penalty") double frequencyPenalty, @JsonProperty(value="max_tokens") int maxTokens, @JsonProperty(value="best_of") int bestOf, @JsonProperty(value="user") String user, @JsonProperty(value="stop_sequences") List<String> stopSequences) {
            this.temperature = temperature;
            this.topP = topP;
            this.presencePenalty = presencePenalty;
            this.frequencyPenalty = frequencyPenalty;
            this.maxTokens = maxTokens;
            this.bestOf = Math.max(1, bestOf);
            if (user == null) {
                user = "";
            }
            this.user = user;
            if (stopSequences == null) {
                stopSequences = new ArrayList<String>();
            }
            this.stopSequences = stopSequences;
        }

        public double getTemperature() {
            return this.temperature;
        }

        public double getTopP() {
            return this.topP;
        }

        public double getPresencePenalty() {
            return this.presencePenalty;
        }

        public double getFrequencyPenalty() {
            return this.frequencyPenalty;
        }

        public int getMaxTokens() {
            return this.maxTokens;
        }

        public int getBestOf() {
            return this.bestOf;
        }

        public String getUser() {
            return this.user;
        }
    }

    public static class CompletionConfigBuilder {
        private CompletionConfig completionConfig;

        public CompletionConfigBuilder() {
            this.completionConfig = new CompletionConfig();
        }

        public CompletionConfigBuilder(CompletionConfig completionConfig) {
            this.completionConfig = completionConfig;
        }

        public CompletionConfigBuilder temperature(double temperature) {
            return new CompletionConfigBuilder(new CompletionConfig(temperature, this.completionConfig.topP, this.completionConfig.presencePenalty, this.completionConfig.frequencyPenalty, this.completionConfig.maxTokens, this.completionConfig.bestOf, this.completionConfig.user, this.completionConfig.stopSequences));
        }

        public CompletionConfigBuilder topP(double topP) {
            return new CompletionConfigBuilder(new CompletionConfig(this.completionConfig.temperature, topP, this.completionConfig.presencePenalty, this.completionConfig.frequencyPenalty, this.completionConfig.maxTokens, this.completionConfig.bestOf, this.completionConfig.user, this.completionConfig.stopSequences));
        }

        public CompletionConfigBuilder presencePenalty(double presencePenalty) {
            return new CompletionConfigBuilder(new CompletionConfig(this.completionConfig.temperature, this.completionConfig.topP, presencePenalty, this.completionConfig.frequencyPenalty, this.completionConfig.maxTokens, this.completionConfig.bestOf, this.completionConfig.user, this.completionConfig.stopSequences));
        }

        public CompletionConfigBuilder frequencyPenalty(double frequencyPenalty) {
            return new CompletionConfigBuilder(new CompletionConfig(this.completionConfig.temperature, this.completionConfig.topP, this.completionConfig.presencePenalty, frequencyPenalty, this.completionConfig.maxTokens, this.completionConfig.bestOf, this.completionConfig.user, this.completionConfig.stopSequences));
        }

        public CompletionConfigBuilder maxTokens(int maxTokens) {
            return new CompletionConfigBuilder(new CompletionConfig(this.completionConfig.temperature, this.completionConfig.topP, this.completionConfig.presencePenalty, this.completionConfig.frequencyPenalty, maxTokens, this.completionConfig.bestOf, this.completionConfig.user, this.completionConfig.stopSequences));
        }

        public CompletionConfigBuilder stopSequences(List<String> stopSequences) {
            return new CompletionConfigBuilder(new CompletionConfig(this.completionConfig.temperature, this.completionConfig.topP, this.completionConfig.presencePenalty, this.completionConfig.frequencyPenalty, this.completionConfig.maxTokens, this.completionConfig.bestOf, this.completionConfig.user, stopSequences));
        }

        public CompletionConfig build() {
            return this.completionConfig;
        }
    }
}

