/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.services;

import com.microsoft.semantickernel.Verify;
import com.microsoft.semantickernel.services.AIService;
import com.microsoft.semantickernel.services.AIServiceProvider;
import com.microsoft.semantickernel.services.DefaultAIServiceProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class AIServiceCollection {
    private static final String DefaultKey = "__DEFAULT__";
    private final Map<Class<? extends AIService>, Map<String, Supplier<? extends AIService>>> services = new HashMap<Class<? extends AIService>, Map<String, Supplier<? extends AIService>>>();
    private final Map<Class<? extends AIService>, String> defaultIds = new HashMap<Class<? extends AIService>, String>();

    public <T extends AIService> void setService(T service, Class<T> serviceType) {
        this.setService(DefaultKey, () -> service, true, serviceType);
    }

    public <T extends AIService> void setService(String name, T service, boolean setAsDefault, Class<T> serviceType) {
        this.setService(name, () -> service, setAsDefault, serviceType);
    }

    public <T extends AIService> void setService(Supplier<T> factory, Class<T> serviceType) {
        this.setService(DefaultKey, factory, true, serviceType);
    }

    public <T extends AIService> void setService(@Nullable String name, Supplier<T> factory, boolean setAsDefault, Class<T> serviceType) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        Map<String, Supplier<? extends AIService>> namedServices = this.services.get(serviceType);
        if (namedServices == null) {
            namedServices = new HashMap<String, Supplier<? extends AIService>>();
            this.services.put(serviceType, namedServices);
        }
        if (name == null || setAsDefault || !this.hasDefault(serviceType)) {
            this.defaultIds.put(serviceType, name == null ? DefaultKey : name);
        }
        namedServices.put(name == null ? DefaultKey : name, factory);
    }

    public AIServiceProvider build() {
        Map<Class<? extends AIService>, Map<String, Supplier<? extends AIService>>> servicesClone = AIServiceCollection.cloneServices(this.services);
        HashMap<Class<? extends AIService>, String> defaultsClone = new HashMap<Class<? extends AIService>, String>(this.defaultIds);
        return new DefaultAIServiceProvider(servicesClone, (Map<Class<? extends AIService>, String>)defaultsClone);
    }

    static <T> Map<Class<? extends T>, Map<String, Supplier<? extends T>>> cloneServices(Map<Class<? extends T>, Map<String, Supplier<? extends T>>> services) {
        return Collections.unmodifiableMap(services.entrySet().stream().reduce(new HashMap(), (a, b) -> {
            a.put((Class)b.getKey(), Collections.unmodifiableMap((Map)b.getValue()));
            return a;
        }, (a, b) -> {
            a.putAll(b);
            return a;
        }));
    }

    private <T extends AIService> boolean hasDefault(Class<T> type) {
        String defaultName = this.defaultIds.get(type);
        return !Verify.isNullOrEmpty(defaultName);
    }
}

