/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.textcompletion;

import com.microsoft.semantickernel.semanticfunctions.PromptTemplateConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompletionRequestSettings {
    private final double temperature;
    private final double topP;
    private final double presencePenalty;
    private final double frequencyPenalty;
    private final int maxTokens;
    private final List<String> stopSequences;
    private final int bestOf;
    private final String user;

    public CompletionRequestSettings(double temperature, double topP, double presencePenalty, double frequencyPenalty, int maxTokens) {
        this(temperature, topP, presencePenalty, frequencyPenalty, maxTokens, 1, "", Collections.emptyList());
    }

    public CompletionRequestSettings(double temperature, double topP, double presencePenalty, double frequencyPenalty, int maxTokens, int bestOf, String user, List<String> stopSequences) {
        this.temperature = temperature;
        this.topP = topP;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.maxTokens = maxTokens;
        this.bestOf = bestOf;
        this.user = user;
        this.stopSequences = new ArrayList<String>(stopSequences);
    }

    public CompletionRequestSettings() {
        this(0.0, 0.0, 0.0, 0.0, 256, 1, "", new ArrayList<String>());
    }

    public static CompletionRequestSettings fromCompletionConfig(PromptTemplateConfig.CompletionConfig config) {
        return new CompletionRequestSettings(config.getTemperature(), config.getTopP(), config.getPresencePenalty(), config.getFrequencyPenalty(), config.getMaxTokens(), config.getBestOf(), config.getUser(), new ArrayList<String>());
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getTopP() {
        return this.topP;
    }

    public double getPresencePenalty() {
        return this.presencePenalty;
    }

    public double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public List<String> getStopSequences() {
        return Collections.unmodifiableList(this.stopSequences);
    }

    public Integer getBestOf() {
        return this.bestOf;
    }

    public String getUser() {
        return this.user;
    }
}

