/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.ai;

import com.microsoft.semantickernel.SKException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AIException
extends SKException {
    @Nonnull
    private final ErrorCodes errorCode;

    public AIException(@Nonnull ErrorCodes error) {
        this(error, null, null);
    }

    public AIException(@Nonnull ErrorCodes errorCode, @Nullable String message) {
        this(errorCode, message, null);
    }

    public AIException(@Nonnull ErrorCodes errorCode, @Nullable String message, @Nullable Throwable innerException) {
        super(AIException.getDefaultMessage(errorCode, message), innerException);
        this.errorCode = errorCode;
    }

    public ErrorCodes getErrorCode() {
        return this.errorCode;
    }

    private static String getDefaultMessage(@Nonnull ErrorCodes errorCode, @Nullable String message) {
        return String.format("%s: %s", errorCode.getMessage(), message);
    }

    public static enum ErrorCodes {
        UnknownError("Unknown error"),
        NoResponse("No response"),
        AccessDenied("Access is denied"),
        InvalidRequest("The request was invalid"),
        InvalidResponseContent("The content of the response was invalid"),
        Throttling("The request was throttled"),
        RequestTimeout("The request timed out"),
        ServiceError("There was an error in the service"),
        ModelNotAvailable("The requested model is not available"),
        InvalidConfiguration("The supplied configuration was invalid"),
        FunctionTypeNotSupported("The function is not supported");

        private final String message;

        private ErrorCodes(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

