/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.builders;

import com.microsoft.semantickernel.Kernel;
import com.microsoft.semantickernel.ai.embeddings.EmbeddingGeneration;
import com.microsoft.semantickernel.builders.Buildable;
import com.microsoft.semantickernel.builders.SemanticKernelBuilder;
import com.microsoft.semantickernel.builders.ServiceLoadUtil;
import com.microsoft.semantickernel.chatcompletion.ChatCompletion;
import com.microsoft.semantickernel.memory.MemoryStore;
import com.microsoft.semantickernel.memory.SemanticTextMemory;
import com.microsoft.semantickernel.orchestration.ContextVariables;
import com.microsoft.semantickernel.orchestration.SKContext;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplate;
import com.microsoft.semantickernel.skilldefinition.ReadOnlySkillCollection;
import com.microsoft.semantickernel.templateengine.PromptTemplateEngine;
import com.microsoft.semantickernel.textcompletion.CompletionSKFunction;
import com.microsoft.semantickernel.textcompletion.TextCompletion;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum BuildersSingleton {
    INST;

    private static final String FALLBACK_COMPLETION_FUNCTION_BUILDER_CLASS = "com.microsoft.semantickernel.orchestration.DefaultCompletionSKFunction$Builder";
    private static final String FALLBACK_KERNEL_BUILDER_CLASS = "com.microsoft.semantickernel.DefaultKernel$Builder";
    private static final String FALLBACK_TEXT_COMPLETION_BUILDER_CLASS = "com.microsoft.semantickernel.connectors.ai.openai.textcompletion.OpenAITextCompletion$Builder";
    private static final String FALLBACK_TEXT_EMBEDDING_GENERATION_BUILDER_CLASS = "com.microsoft.semantickernel.connectors.ai.openai.textembeddings.OpenAITextEmbeddingGeneration$Builder";
    private static final String FALLBACK_SKILL_COLLECTION_BUILDER_CLASS = "com.microsoft.semantickernel.skilldefinition.DefaultSkillCollection$Builder";
    private static final String FALLBACK_PROMPT_TEMPLATE_BUILDER_CLASS = "com.microsoft.semantickernel.semanticfunctions.DefaultPromptTemplate$Builder";
    private static final String FALLBACK_VARIABLE_BUILDER_CLASS = "com.microsoft.semantickernel.orchestration.DefaultContextVariables$Builder";
    private static final String FALLBACK_CONTEXT_BUILDER_CLASS = "com.microsoft.semantickernel.orchestration.DefaultSKContext$Builder";
    private static final String FALLBACK_PROMPT_TEMPLATE_ENGINE_BUILDER_CLASS = "com.microsoft.semantickernel.templateengine.DefaultPromptTemplateEngine$Builder";
    private static final String FALLBACK_SEMANTIC_TEXT_MEMORY_CLASS = "com.microsoft.semantickernel.memory.DefaultSemanticTextMemory$Builder";
    private static final String FALLBACK_CHAT_COMPLETION_BUILDER_CLASS = "com.microsoft.semantickernel.connectors.ai.openai.chatcompletion.OpenAIChatCompletion$Builder";
    private static final String FALLBACK_MEMORY_STORE_BUILDER_CLASS = "com.microsoft.semantickernel.memory.VolatileMemoryStore$Builder";
    private final Map<Class<? extends SemanticKernelBuilder>, Supplier<? extends Buildable>> builders = new HashMap<Class<? extends SemanticKernelBuilder>, Supplier<? extends Buildable>>();

    private BuildersSingleton() {
        try {
            this.registerBuilder(CompletionSKFunction.Builder.class, FALLBACK_COMPLETION_FUNCTION_BUILDER_CLASS);
            this.registerBuilder(Kernel.Builder.class, FALLBACK_KERNEL_BUILDER_CLASS);
            this.registerBuilder(TextCompletion.Builder.class, FALLBACK_TEXT_COMPLETION_BUILDER_CLASS);
            this.registerBuilder(EmbeddingGeneration.Builder.class, FALLBACK_TEXT_EMBEDDING_GENERATION_BUILDER_CLASS);
            this.registerBuilder(ReadOnlySkillCollection.Builder.class, FALLBACK_SKILL_COLLECTION_BUILDER_CLASS);
            this.registerBuilder(PromptTemplate.Builder.class, FALLBACK_PROMPT_TEMPLATE_BUILDER_CLASS);
            this.registerBuilder(ContextVariables.Builder.class, FALLBACK_VARIABLE_BUILDER_CLASS);
            this.registerBuilder(SemanticTextMemory.Builder.class, FALLBACK_SEMANTIC_TEXT_MEMORY_CLASS);
            this.registerBuilder(SKContext.Builder.class, FALLBACK_CONTEXT_BUILDER_CLASS);
            this.registerBuilder(PromptTemplateEngine.Builder.class, FALLBACK_PROMPT_TEMPLATE_ENGINE_BUILDER_CLASS);
            this.registerBuilder(ChatCompletion.Builder.class, FALLBACK_CHAT_COMPLETION_BUILDER_CLASS);
            this.registerBuilder(MemoryStore.Builder.class, FALLBACK_MEMORY_STORE_BUILDER_CLASS);
        }
        catch (Throwable e) {
            Logger LOGGER = LoggerFactory.getLogger(BuildersSingleton.class);
            LOGGER.error("Failed to discover Semantic Kernel Builders", e);
            LOGGER.error("This is likely due to:\n\n- The Semantic Kernel implementation (typically provided by semantickernel-core) is not present on the classpath at runtime, ensure that this dependency is available at runtime. In maven this would be achieved by adding:\n\n        <dependency>\n            <groupId>com.microsoft.semantickernel</groupId>\n            <artifactId>semantickernel-core</artifactId>\n            <version>${skversion}</version>\n            <scope>runtime</scope>\n        </dependency>\n\n- The META-INF/services files that define the service loading have been filtered out and are not present within the running application\n\n- The class names have been changed (for instance shaded) preventing discovering the classes");
            throw e;
        }
    }

    private <U extends Buildable, T extends SemanticKernelBuilder<U>> void registerBuilder(Class<T> clazz, String fallbackClassName) {
        this.builders.put(clazz, ServiceLoadUtil.findServiceLoader(clazz, fallbackClassName));
    }

    public <U extends Buildable, T extends SemanticKernelBuilder<U>> T getInstance(Class<T> clazz) {
        return (T)((SemanticKernelBuilder)((Object)this.builders.get(clazz).get()));
    }

    public TextCompletion.Builder getTextCompletionBuilder() {
        return this.getInstance(TextCompletion.Builder.class);
    }

    public EmbeddingGeneration.Builder<String> getTextEmbeddingGenerationBuilder() {
        return this.getInstance(EmbeddingGeneration.Builder.class);
    }

    public ReadOnlySkillCollection.Builder getReadOnlySkillCollection() {
        return this.getInstance(ReadOnlySkillCollection.Builder.class);
    }

    public PromptTemplate.Builder getPromptTemplateBuilder() {
        return this.getInstance(PromptTemplate.Builder.class);
    }

    public PromptTemplateEngine.Builder getPromptTemplateEngineBuilder() {
        return this.getInstance(PromptTemplateEngine.Builder.class);
    }

    public ContextVariables.Builder variables() {
        return this.getInstance(ContextVariables.Builder.class);
    }

    public SKContext.Builder context() {
        return this.getInstance(SKContext.Builder.class);
    }

    public SemanticTextMemory.Builder getSemanticTextMemoryBuilder() {
        return this.getInstance(SemanticTextMemory.Builder.class);
    }

    public ChatCompletion.Builder getChatCompletion() {
        return this.getInstance(ChatCompletion.Builder.class);
    }

    public MemoryStore.Builder getMemoryStoreBuilder() {
        return this.getInstance(MemoryStore.Builder.class);
    }
}

