/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.chatcompletion;

import com.azure.ai.openai.OpenAIAsyncClient;
import com.azure.ai.openai.models.ChatCompletions;
import com.microsoft.semantickernel.builders.Buildable;
import com.microsoft.semantickernel.builders.BuildersSingleton;
import com.microsoft.semantickernel.builders.SemanticKernelBuilder;
import com.microsoft.semantickernel.chatcompletion.ChatHistory;
import com.microsoft.semantickernel.chatcompletion.ChatRequestSettings;
import com.microsoft.semantickernel.services.AIService;
import com.microsoft.semantickernel.textcompletion.TextCompletion;
import javax.annotation.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ChatCompletion<ChatHistoryType extends ChatHistory>
extends AIService,
TextCompletion,
Buildable {
    public Mono<String> generateMessageAsync(ChatHistoryType var1, @Nullable ChatRequestSettings var2);

    public ChatHistoryType createNewChat(@Nullable String var1);

    public Flux<String> generateMessageStream(ChatHistoryType var1, @Nullable ChatRequestSettings var2);

    public Flux<ChatCompletions> getStreamingChatCompletionsAsync(ChatHistoryType var1, ChatRequestSettings var2);

    public static Builder builder() {
        return BuildersSingleton.INST.getInstance(Builder.class);
    }

    public static interface Builder
    extends SemanticKernelBuilder<ChatCompletion> {
        public Builder withOpenAIClient(OpenAIAsyncClient var1);

        public Builder setModelId(String var1);
    }
}

