/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.extensions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.semantickernel.KernelException;
import com.microsoft.semantickernel.SKBuilders;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplate;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplateConfig;
import com.microsoft.semantickernel.semanticfunctions.SemanticFunctionConfig;
import com.microsoft.semantickernel.templateengine.PromptTemplateEngine;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KernelExtensions {
    private static final Logger LOGGER = LoggerFactory.getLogger(KernelExtensions.class);
    private static final String CONFIG_FILE = "config.json";
    private static final String PROMPT_FILE = "skprompt.txt";

    private KernelExtensions() {
    }

    public static Map<String, SemanticFunctionConfig> importSemanticSkillFromDirectory(String parentDirectory, String skillDirectoryName, PromptTemplateEngine promptTemplateEngine) {
        File skillDir = new File(parentDirectory, skillDirectoryName);
        File[] files = skillDir.listFiles();
        if (files == null) {
            throw new KernelException(KernelException.ErrorCodes.FunctionNotAvailable, "No Skills found in directory " + skillDir.getAbsolutePath());
        }
        HashMap<String, SemanticFunctionConfig> skills = new HashMap<String, SemanticFunctionConfig>();
        for (File dir : files) {
            try {
                File promptPath = new File(dir, PROMPT_FILE);
                if (!promptPath.exists()) continue;
                PromptTemplateConfig config = new PromptTemplateConfig("", "", null);
                File configPath = new File(dir, CONFIG_FILE);
                if (configPath.exists()) {
                    config = (PromptTemplateConfig)new ObjectMapper().readValue(configPath, PromptTemplateConfig.class);
                }
                String template = new String(Files.readAllBytes(promptPath.toPath()), Charset.defaultCharset());
                PromptTemplate promptTemplate = (PromptTemplate)SKBuilders.promptTemplate().setPromptTemplate(template).setPromptTemplateConfig(config).setPromptTemplateEngine(promptTemplateEngine).build();
                skills.put(dir.getName(), new SemanticFunctionConfig(config, promptTemplate));
            }
            catch (IOException e) {
                LOGGER.error("Failed to read file", (Throwable)e);
            }
        }
        return skills;
    }

    public static Map<String, SemanticFunctionConfig> importSemanticSkillFromResourcesDirectory(String pluginDirectory, String pluginName, String functionName, @Nullable Class clazz, PromptTemplateEngine promptTemplateEngine) {
        PromptTemplateConfig config = KernelExtensions.getPromptTemplateConfig(pluginDirectory, pluginName, functionName, clazz);
        if (config == null) {
            config = new PromptTemplateConfig("", "", null);
        }
        String template = KernelExtensions.getTemplatePrompt(pluginDirectory, pluginName, functionName, clazz);
        HashMap<String, SemanticFunctionConfig> skills = new HashMap<String, SemanticFunctionConfig>();
        PromptTemplate promptTemplate = (PromptTemplate)SKBuilders.promptTemplate().setPromptTemplate(template).setPromptTemplateConfig(config).setPromptTemplateEngine(promptTemplateEngine).build();
        skills.put(functionName, new SemanticFunctionConfig(config, promptTemplate));
        return skills;
    }

    private static String getTemplatePrompt(String pluginDirectory, String pluginName, String functionName, @Nullable Class clazz) {
        String template;
        String promptFileName = pluginDirectory + File.separator + pluginName + File.separator + functionName + File.separator + PROMPT_FILE;
        InputStream promptFileStream = clazz == null ? KernelExtensions.class.getClassLoader().getResourceAsStream(promptFileName) : clazz.getResourceAsStream(promptFileName);
        try (BufferedReader promptFile = new BufferedReader(new InputStreamReader(promptFileStream, Charset.defaultCharset()));){
            template = promptFile.lines().collect(Collectors.joining("\n"));
        }
        catch (IOException e) {
            LOGGER.error("Failed to read file " + promptFileName, (Throwable)e);
            throw new KernelException(KernelException.ErrorCodes.FunctionNotAvailable, "No Skills found in directory " + promptFileName);
        }
        return template;
    }

    private static PromptTemplateConfig getPromptTemplateConfig(String pluginDirectory, String pluginName, String functionName, @Nullable Class clazz) {
        PromptTemplateConfig promptTemplateConfig;
        block9: {
            String configFileName = pluginDirectory + File.separator + pluginName + File.separator + functionName + File.separator + CONFIG_FILE;
            InputStream configFileStream = clazz == null ? KernelExtensions.class.getClassLoader().getResourceAsStream(configFileName) : clazz.getResourceAsStream(configFileName);
            if (configFileStream == null) {
                return null;
            }
            InputStream is = configFileStream;
            try {
                promptTemplateConfig = (PromptTemplateConfig)new ObjectMapper().readValue(is, PromptTemplateConfig.class);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.debug("No config for " + functionName + " in " + pluginName);
                    return null;
                }
            }
            is.close();
        }
        return promptTemplateConfig;
    }
}

